/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.customers.service.vip;

import cc.lechun.customers.entity.customer.CustomerEntity;
import cc.lechun.customers.entity.vip.MallVipConditionEntity;
import cc.lechun.customers.entity.vip.MallVipEntity;
import cc.lechun.customers.entity.vip.MallVipRewardsRelationEntity;
import cc.lechun.customers.entity.vip.MallVipTasksRelationEntity;
import cc.lechun.customers.iservice.customer.CustomerInterface;
import cc.lechun.customers.iservice.vip.MallVipConditionInterface;
import cc.lechun.customers.iservice.vip.MallVipInterface;
import cc.lechun.customers.iservice.vip.MallVipLogInterface;
import cc.lechun.customers.iservice.vip.MallVipRewardsInterface;
import cc.lechun.customers.iservice.vip.MallVipRewardsRelationInterface;
import cc.lechun.customers.iservice.vip.MallVipRightsInterface;
import cc.lechun.customers.iservice.vip.MallVipTasksInterface;
import cc.lechun.customers.iservice.vip.MallVipTasksRelationInterface;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallVipService
extends BaseService<MallVipEntity, String>
implements MallVipInterface {
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MallVipConditionInterface mallVipConditionInterface;
    @Autowired
    private MallVipRewardsRelationInterface mallVipRewardsRelationInterface;
    @Autowired
    private MallVipRewardsInterface mallVipRewardsInterface;
    @Autowired
    private MallVipRightsInterface mallVipRightsInterface;
    @Autowired
    private MallVipLogInterface mallVipLogInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private MallVipInterface mallVipInterface;
    @Autowired
    private MallVipTasksRelationInterface mallVipTasksRelationInterface;
    @Autowired
    private MallVipTasksInterface mallVipTasksInterface;

    public Map<String, Object> centerInfo(@ParameterValueKeyProvider String customerId) {
        CustomerEntity customer = this.customerInterface.getCustomer(customerId);
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        List conditionList = this.mallVipConditionInterface.conditionList(customer.getPlatformGroupId());
        ArrayList conditions = new ArrayList();
        for (MallVipConditionEntity condition : conditionList) {
            HashMap<String, Object> _condition = new HashMap<String, Object>();
            _condition.put("ID", condition.getId());
            _condition.put("LEVEL", condition.getLevel());
            _condition.put("ORDER_NUM", condition.getOrderNum());
            _condition.put("LEVEL_IMG_URL", "");
            conditions.add(_condition);
        }
        rtnMap.put("CONDITIONS", conditions);
        Integer orderCount = 0;
        Integer curLevel = (int)this.getUserVipInfo(customerId).getLevel();
        rtnMap.put("ORDER_COUNT", orderCount);
        rtnMap.put("CURRENT_LEVEL", curLevel);
        List userRewards = this.mallVipRewardsRelationInterface.findUserRewards(customerId);
        List vipRewards = this.mallVipRewardsInterface.findVipHasnotRewards(curLevel);
        userRewards.addAll(vipRewards);
        List vipRightsHas = this.mallVipRightsInterface.findVipHasRights(curLevel);
        List vipRightsHasNot = this.mallVipRightsInterface.findVipHasNotRights(curLevel);
        vipRightsHasNot.addAll(vipRightsHas);
        ArrayList levelSet = new ArrayList();
        for (MallVipConditionEntity condition : conditionList) {
            HashMap<String, Object> levelRtnRecord = new HashMap<String, Object>();
            levelRtnRecord.put("ORDER_COUNT_DIFF", condition.getOrderNum() - orderCount < 0 ? 0 : condition.getOrderNum() - orderCount);
            levelRtnRecord.put("LEVEL", condition.getLevel());
            if (condition.getLevel() <= curLevel) {
                Map thisLevelTime = this.mallVipLogInterface.findCustomerLevelUpTime(customerId, condition.getLevel());
                if (thisLevelTime != null && thisLevelTime.size() > 0) {
                    levelRtnRecord.put("THIS_LEVEL_TIME", thisLevelTime.get("CREATE_TIME"));
                } else {
                    levelRtnRecord.put("THIS_LEVEL_TIME", "");
                }
                levelRtnRecord.put("LIGHT", "ON");
            } else {
                levelRtnRecord.put("THIS_LEVEL_TIME", "");
                levelRtnRecord.put("LIGHT", "OFF");
            }
            ArrayList<Map> rewardsRecordSet = new ArrayList<Map>();
            for (Map reward : userRewards) {
                if (((Integer)reward.get("LEVEL")).intValue() != condition.getLevel().intValue()) continue;
                if ("ON".equals(reward.get("LIGHT"))) {
                    // empty if block
                }
                rewardsRecordSet.add(reward);
            }
            levelRtnRecord.put("REWARDS", rewardsRecordSet);
            ArrayList<Map> rightsRecordSet = new ArrayList<Map>();
            for (Map right : vipRightsHasNot) {
                if (((Integer)right.get("LEVEL")).intValue() != condition.getLevel().intValue()) continue;
                if ("ON".equals(right.get("LIGHT"))) {
                    // empty if block
                }
                if (right.get("RIGHT_IMG_URL") != null && StringUtils.isNotEmpty((String)String.valueOf(right.get("RIGHT_IMG_URL")))) {
                    right.put("SHOW_POP", 1);
                } else {
                    right.put("SHOW_POP", 0);
                }
                if (Integer.valueOf(String.valueOf(right.get("STATUS"))) == 0) {
                    right.put("HAS_RECEIVED", 3);
                }
                rightsRecordSet.add(right);
            }
            levelRtnRecord.put("RIGHTS", rightsRecordSet);
            levelSet.add(levelRtnRecord);
        }
        rtnMap.put("LEVELS_DATA", levelSet);
        return rtnMap;
    }

    public MallVipEntity getUserVipInfo(String customerId) {
        MallVipEntity searchParam = new MallVipEntity();
        if (customerId.isEmpty()) {
            searchParam.setPlatformGroupId(Integer.valueOf(0));
            searchParam.setLevel(Integer.valueOf(0));
            return searchParam;
        }
        searchParam.setCustomerId(customerId);
        MallVipEntity entity = (MallVipEntity)this.getSingle((Object)searchParam);
        if (entity == null || entity.getLevel() == null) {
            searchParam.setPlatformGroupId(this.customerInterface.getCustomer(customerId).getPlatformGroupId());
            searchParam.setLevel(Integer.valueOf(0));
            return searchParam;
        }
        return entity;
    }

    public BaseJsonVo updateVipLevel(String customerId, Integer level) {
        MallVipEntity vip = this.getUserVipInfo(customerId);
        int sourceLevel = vip.getLevel();
        int targetLevel = level;
        this.deleteUserVipInfoCache(customerId);
        BaseJsonVo vo = null;
        if (sourceLevel == 0) {
            vip.setId(IDGenerate.getUniqueIdStr());
            vip.setIsReward(Integer.valueOf(0));
            vip.setLevel(Integer.valueOf(targetLevel));
            vo = this.insert((Object)vip) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5347\u7ea7\u5931\u8d25");
        } else {
            vip.setLevel(Integer.valueOf(targetLevel));
            vo = this.updateByPrimaryKeySelective((Object)vip) >= 1 ? BaseJsonVo.success((Object)"") : BaseJsonVo.error((String)"\u5347\u7ea7\u5931\u8d25");
        }
        this.mallVipInterface.customerVipTaskRelation(customerId);
        this.mallVipInterface.customerVipRewardRelation(customerId);
        this.mallVipLogInterface.saveVipLog(customerId, vip, sourceLevel);
        return vo;
    }

    public void deleteUserVipInfoCache(String customerId) {
        this.memcachedService.delete("VIP", customerId);
        this.memcachedService.delete("VIP_CENTER_INFO", customerId);
    }

    @Transactional
    public void customerVipTaskRelation(String customerId) {
        CustomerEntity customer = this.customerInterface.getCustomer(customerId);
        MallVipEntity vip = this.mallVipInterface.getUserVipInfo(customerId);
        Integer curLevel = vip.getLevel();
        List conditions = this.mallVipConditionInterface.conditionList(customer.getPlatformGroupId());
        conditions.forEach(condition -> {
            List checkTaskRelations;
            if (curLevel >= condition.getLevel() && ((checkTaskRelations = this.mallVipTasksRelationInterface.findThisLevelTasksRelation(customerId, condition.getLevel())) == null || checkTaskRelations.size() == 0)) {
                List tasks = this.mallVipTasksInterface.findTasksByLevel(condition.getLevel());
                List taskRelations = this.mallVipTasksRelationInterface.findCustomerTasksRelation(customerId);
                tasks.forEach(task -> {
                    if (!"3164445118971216140".equals(task.getId()) || this.mallVipTasksRelationInterface.isFinishedTask5yuan(customerId).booleanValue()) {
                        // empty if block
                    }
                    if (!("3164420955670229136".equals(task.getId()) && this.mallVipTasksRelationInterface.isFinishedTask12ask(customerId).booleanValue() || taskRelations.stream().anyMatch(taskRelation -> taskRelation.getTaskId().equals(task.getId())))) {
                        MallVipTasksRelationEntity entity = new MallVipTasksRelationEntity();
                        entity.setId(IDGenerate.getUniqueIdStr());
                        entity.setCustomerId(customerId);
                        entity.setTaskId(task.getId());
                        entity.setTaskType(task.getTaskType());
                        entity.setTaskName(task.getTaskName());
                        entity.setPlatformGroupId(this.customerInterface.getCustomer(customerId).getPlatformGroupId());
                        entity.setIsFinished("0");
                        entity.setRecommendTimes(Integer.valueOf(0));
                        this.mallVipTasksRelationInterface.insert((Object)entity);
                    }
                });
            }
        });
    }

    @Transactional
    public void customerVipRewardRelation(String customerId) {
        CustomerEntity customer = this.customerInterface.getCustomer(customerId);
        MallVipEntity vip = this.mallVipInterface.getUserVipInfo(customerId);
        Integer curLevel = vip.getLevel();
        List conditions = this.mallVipConditionInterface.conditionList(customer.getPlatformGroupId());
        conditions.forEach(condition -> {
            List checkRewardsRelations;
            if (curLevel >= condition.getLevel() && ((checkRewardsRelations = this.mallVipRewardsRelationInterface.findThisLevelRewardsRelation(customerId, condition.getLevel())) == null || checkRewardsRelations.size() == 0)) {
                List rewards = this.mallVipRewardsInterface.findRewardsByLevel(condition.getLevel());
                List rewardsRelations = this.mallVipRewardsRelationInterface.findCustomerRewardsRelation(customerId);
                ArrayList sqls = new ArrayList();
                rewards.forEach(reward -> {
                    if (!rewardsRelations.stream().anyMatch(rewardRelation -> rewardRelation.getRewardId().equals(reward.getId()))) {
                        MallVipRewardsRelationEntity entity = new MallVipRewardsRelationEntity();
                        entity.setId(IDGenerate.getUniqueIdStr());
                        entity.setCustomerId(customerId);
                        entity.setRewardId(reward.getId());
                        entity.setRewardName(reward.getRewardName());
                        entity.setRewardType(reward.getRewardType());
                        entity.setPlatformGroupId(this.customerInterface.getCustomer(customerId).getPlatformGroupId());
                        entity.setHasReceived("0");
                        this.mallVipRewardsRelationInterface.insert((Object)entity);
                    }
                });
            }
        });
    }
}

