/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.web;

import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtil {
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);

    public static String getCliectIp(HttpServletRequest request) {
        String ipAddress = null;
        ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress != null && ipAddress.length() != 0 && !"unknown".equalsIgnoreCase(ipAddress) || (ipAddress = request.getRemoteAddr()).equals("127.0.0.1")) {
            // empty if block
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static InetAddress getLocalHostLANAddress() {
        try {
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6IP\u5730\u5740\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public static String getCityIdByIp(String ip) {
        if (StringUtils.isEmpty((String)ip)) {
            return null;
        }
        try {
            String cityUrl = "http://ip.taobao.com/service/getIpInfo.php";
            String s = HttpRequest.get(cityUrl, "ip=" + ip.split(",")[0]);
            Map r = JsonUtils.fromJson(s, HashMap.class);
            if (r.containsKey("data") && r.get("data") != null) {
                LinkedHashMap rr = (LinkedHashMap)r.get("data");
                return String.valueOf(rr.get("city"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

