/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.web;

import cc.lechun.framework.common.utils.cache.RedisCacheUtil;
import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IpUtil {
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);
    private static RedisCacheUtil redisCacheUtil;
    @Autowired
    private RedisCacheUtil _redisCacheUtil;

    @PostConstruct
    public void init() {
        redisCacheUtil = this._redisCacheUtil;
    }

    public static String getCliectIp(HttpServletRequest request) {
        String ipAddress = null;
        ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress != null && ipAddress.length() != 0 && !"unknown".equalsIgnoreCase(ipAddress) || (ipAddress = request.getRemoteAddr()).equals("127.0.0.1")) {
            // empty if block
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static InetAddress getLocalHostLANAddress() {
        try {
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6IP\u5730\u5740\u9519\u8bef", (Throwable)e);
            return null;
        }
    }

    public static String getCityIdByIp(String ip) {
        String key = "iputil_getCityIdByIp" + ip;
        if (StringUtils.isEmpty((String)ip)) {
            return null;
        }
        Object o = redisCacheUtil.get(key);
        if (o != null) {
            return o.toString();
        }
        String result = IpUtil.baiduIp(ip);
        if (StringUtils.isEmpty((String)result)) {
            result = IpUtil.gaodeIp(ip);
        }
        if (StringUtils.isNotEmpty((String)result)) {
            redisCacheUtil.set(key, result, 31536000L);
        }
        return result;
    }

    private static String baiduIp(String ip) {
        try {
            String rr;
            String cityUrl = "http://api.map.baidu.com/location/ip";
            String s = HttpRequest.get(cityUrl, "ak=827c6dd4b8f06ecc01162f44bf2e3ffd&coor=bd09ll&ip=" + ip.split(",")[0]);
            Map r = JsonUtils.fromJson(s, HashMap.class);
            if (r.containsKey("address") && r.get("address") != null && StringUtils.isNotEmpty((String)(rr = (String)r.get("address")))) {
                String result = rr.split("\\|")[2];
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String gaodeIp(String ip) {
        try {
            String cityUrl = "https://restapi.amap.com/v3/ip";
            String s = HttpRequest.get(cityUrl, "key=a267a66e42966e20659059a3c33c24a2&ip=" + ip.split(",")[0]);
            Map r = JsonUtils.fromJson(s, HashMap.class);
            if (r.containsKey("city") && r.get("city") != null) {
                return (String)r.get("city");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

