/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.log;

import cc.lechun.framework.common.utils.http.HttpUtil;
import cc.lechun.framework.common.utils.log.AccessLogEntity;
import cc.lechun.framework.common.utils.log.SqlLogEntity;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AccessLogDBConfig {
    @Value(value="${accessLog.error}")
    private String accessLogError;
    @Value(value="${accessLog.Sql}")
    private String accessLogSql;
    @Value(value="${accessLog.SqlExecTime}")
    private Integer accessLogSqlExecTime;
    @Value(value="${accessLog.WriteLogUrl}")
    private String accessLogWriteLogUrl;

    public void writeErrorDBLog(AccessLogEntity logEntity) {
        if (logEntity == null) {
            return;
        }
        if (StringUtils.isEmpty(this.accessLogWriteLogUrl)) {
            return;
        }
        if ("1".equals(this.accessLogError)) {
            HttpUtil.doPost(this.accessLogWriteLogUrl, ObjectConvert.objectConvertToMap(logEntity));
        }
    }

    public void writeSqlDBLog(SqlLogEntity logEntity) {
        if (logEntity == null) {
            return;
        }
        if (StringUtils.isEmpty(this.accessLogWriteLogUrl)) {
            return;
        }
        if ("1".equals(this.accessLogSql)) {
            long s = logEntity.getRunTimes();
            if (this.accessLogSqlExecTime != null && s >= (long)this.accessLogSqlExecTime.intValue()) {
                HttpUtil.doPost(this.accessLogWriteLogUrl, ObjectConvert.objectConvertToMap(logEntity));
            }
        }
    }
}

