package cc.lechun.framework.common.enums.trade;

import java.util.Arrays;
import java.util.List;

/**
 * Created by liqun on 2018/1/12.
 */
public enum RefundSourceEnum {
    erp(1, "ERP"),
    user(2, "客户"),
    edb(3, "EDB"),
    oms(4,"oms"),
    cms(5,"售后系统");


    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<RefundSourceEnum> getList() {
        return Arrays.asList(RefundSourceEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        RefundSourceEnum[] ls = RefundSourceEnum.values();
        for (RefundSourceEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        RefundSourceEnum[] ls = RefundSourceEnum.values();
        for (RefundSourceEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    RefundSourceEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "ChannelEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
