package cc.lechun.framework.common.utils.cache;

import cc.lechun.framework.common.utils.string.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.*;

/**
 * @Description:
 * @Author hans
 * @Date 2019/8/15 15:22
 * @Version 1.0
 */
@Aspect
@Component
public class RedisLockAOP {
    @Autowired
    RedisCacheUtil redis;

    @Pointcut("@annotation(redisLock)")
    public void redisLockPoint(RedisLock redisLock){}

    @Around("redisLockPoint(redisLock)")
    public Object doAround(ProceedingJoinPoint joinPoint, RedisLock redisLock) throws Throwable {
        Boolean getLockSuccess = false;
        //相同机器相同线程，可重入
        String clientId = InetAddress.getLocalHost().getHostAddress() + " | " + Thread.currentThread().getId();
        StringBuffer key = new StringBuffer(redisLock.key());
        if(key.length() == 0){
            String className = joinPoint.getSignature().getDeclaringTypeName();
            String methodName = joinPoint.getSignature().getName();
            key.append(className).append(".").append(methodName);
        }

        Annotation[][] parameterAnnotations = ((MethodSignature) joinPoint.getSignature()).getMethod().getParameterAnnotations();
        Map<Integer,Object> params = new HashMap<>(parameterAnnotations.length);
        for (int i = 0 ; i < parameterAnnotations.length ; i++) {
            Annotation[] an = parameterAnnotations[i];
            for (Annotation innerAn : an) {
                if(innerAn instanceof RedisLockParameter){
                    params.put(((RedisLockParameter) innerAn).order(),joinPoint.getArgs()[i]);
                }
            }
        }
        List<Integer> index = new ArrayList(params.keySet());
        Collections.sort(index);
        index.forEach(idx -> {
            if(idx != null && params.get(idx) != null){
                key.append(":").append(params.get(idx).toString());
            }
        });
//        System.out.println("redisLock key is : " + key);
//        System.out.println("redisLock value is : " + clientId);
        Long expireTime = redisLock.expire();
        Long waitTime = redisLock.waitTime();
        if(waitTime <= 0){
            getLockSuccess = redis.lock(key.toString(),clientId,expireTime);
        } else {
            getLockSuccess = redis.waitLock(key.toString(),clientId,expireTime,waitTime);
        }
        Object o = null;
        if(getLockSuccess){
//            System.out.println("this key|value got the lock : " + key + "|" + clientId);
            o = joinPoint.proceed();
        }
        redis.releaseLock(key.toString(),clientId);
//        System.out.println("this key|value release the lock : " + key + "|" + clientId);
        return o;
    }
}
