package cc.lechun.framework.common.enums.customer;

/**
 * Created by wangxs on 2018/1/19
 * Description: 密码类型
 */
public enum PasswordTypeEnum {

    login_password(1, "登录密码"),
    pay_password(2, "支付密码");


    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        PasswordTypeEnum[] ls = PasswordTypeEnum.values();
        for (PasswordTypeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    private int value;
    private String name;

    PasswordTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
