package cc.lechun.framework.common.utils.http;

import com.alibaba.fastjson.JSON;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLContext;
import java.io.*;
import java.net.URL;
import java.net.URLConnection;
import java.security.*;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * 类名：HttpRequest 功能：Http请求对象的封装 详细：封装Http请求
 */
public class HttpRequest {

    private static final Logger log = LoggerFactory.getLogger(HttpRequest.class);

    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";

    private int connectTimeout = 15 * 1000;
    private int socketTimeout = 30 * 1000;
    private int connectionRequestTimeout = 5 * 1000;

    private String url = null;
    private String method = METHOD_GET;

    private Map<String, String> params;

    public HttpRequest(String url) {
        this.url = url;
    }

    public HttpRequest(String url, Map<String, String> params) {
        this.url = url;
        this.params = params;
    }

    public HttpRequest(String url, Object params) {
        this.url = url;
        this.params = JSON.parseObject(JSON.toJSONString(params), Map.class);
    }


    /**
     * MAP类型数组转换成NameValuePair类型
     */
    public NameValuePair[] generatNameValuePair() {
        List<NameValuePair> ls = new ArrayList<NameValuePair>();
        Set<Map.Entry<String, String>> entrySet = this.params.entrySet();
        for (Map.Entry<String, String> e : entrySet) {
            String name = e.getKey();
            String value = e.getValue();
            NameValuePair pair = new BasicNameValuePair(name, value);
            ls.add(pair);
        }
        return ls.toArray(new BasicNameValuePair[ls.size()]);
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionRequestTimeout() {
        return connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public static String httpsPost(String url, String param) {
        HttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = "";
        String charset = "utf-8";
        try {
            httpClient = new SslClient();
            httpPost = new HttpPost(url);
            //设置参数
            httpPost.setEntity(new StringEntity(param, "UTF-8"));
            HttpResponse response = httpClient.execute(httpPost);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString(resEntity, charset);
                }
            }
        } catch (Exception ex) {
            log.error("",ex);
        } finally {
            httpClient = null;
            httpPost = null;
        }
        return result;
    }

    public static String httpsPostByDeliver(String url, String param) {
        HttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = "";
        String charset = "utf-8";
        try {
            httpClient = new SslClient();
            httpPost = new HttpPost(url);
            //设置参数
            httpPost.setEntity(new StringEntity(param, "UTF-8"));
            httpPost.setHeader("Content-Type","application/json");

            HttpResponse response = httpClient.execute(httpPost);
            if (response != null) {
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString(resEntity, charset);
                }
            }
        } catch (Exception ex) {
            log.error("",ex);
        } finally {
            httpClient = null;
            httpPost = null;
        }
        return result;
    }
    public static String wechatRefundHttps(String url, String param, String certFileName, String mchId) {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("PKCS12");
        } catch (KeyStoreException e) {
            log.error("",e);
        }

        FileInputStream instream = null;
        try {
            instream = new FileInputStream(new File(certFileName));
            keyStore.load(instream, mchId.toCharArray());
        } catch (IOException e) {
            log.error("",e);
        } catch (NoSuchAlgorithmException e) {
            log.error("",e);
        } catch (CertificateException e) {
            log.error("",e);
        } finally {
            try {
                instream.close();
            } catch (IOException e) {
                log.error("",e);
            }
        }
        // Trust own CA and all self-signed certs
        SSLContext sslcontext = null;
        try {
            sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, mchId.toCharArray())
                    .build();
        } catch (NoSuchAlgorithmException e) {
            log.error("",e);
        } catch (KeyManagementException e) {
            log.error("",e);
        } catch (UnrecoverableKeyException e) {
            log.error("",e);
        } catch (KeyStoreException e) {
            log.error("",e);
        }
        // Allow TLSv1 protocol only
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
                sslcontext,
                new String[]{"TLSv1"},
                null,
                SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        CloseableHttpClient httpclient = HttpClients.custom()
                .setSSLSocketFactory(sslsf)
                .build();
        try {

            HttpPost httpost = new HttpPost("https://api.mch.weixin.qq.com/secapi/pay/refund");
//            HttpGet httpget = new HttpGet("https://api.mch.weixin.qq.com/secapi/pay/refund");
            httpost.addHeader("Connection", "keep-alive");
            httpost.addHeader("Accept", "*/*");
            httpost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            httpost.addHeader("Host", "api.mch.weixin.qq.com");
            httpost.addHeader("X-Requested-With", "XMLHttpRequest");
            httpost.addHeader("Cache-Control", "max-age=0");
            httpost.addHeader("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0) ");
            httpost.setEntity(new StringEntity(param, "UTF-8"));
            System.out.println("executing request" + httpost.getRequestLine());

            CloseableHttpResponse response = null;
            try {
                response = httpclient.execute(httpost);
            } catch (IOException e) {
                log.error("",e);
            }
            try {
                HttpEntity entity = response.getEntity();
                String text = "";
                System.out.println("----------------------------------------");
                System.out.println(response.getStatusLine());
                String sb = "";
                if (entity != null) {
                    System.out.println("Response content length: " + entity.getContentLength());
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(entity.getContent()));

                    while ((text = bufferedReader.readLine()) != null) {
                        sb += text;
                        System.out.println(text);
                    }
                }
                EntityUtils.consume(entity);
                return sb;
            } catch (IOException e) {

            } finally {
                try {
                    response.close();
                } catch (IOException e) {
                    log.error("",e);
                }
            }
        } finally {
            try {
                httpclient.close();
            } catch (IOException e) {
                log.error("",e);
            }
        }
        return "";
    }

    /**
     * 向指定URL发送GET方法的请求
     *
     * @param url   发送请求的URL
     * @param param 请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
     * @return URL 所代表远程资源的响应结果
     */
    public static String get(String url, String param) {
        String result = "";
        BufferedReader in = null;
        try {
            String urlNameString = param.isEmpty() ? url : (url + "?" + param);
            URL realUrl = new URL(urlNameString);
            // 打开和URL之间的连接
            URLConnection connection = realUrl.openConnection();
            // 设置通用的请求属性
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setRequestProperty("charset", "UTF-8");
            connection.setRequestProperty("referer", "http://wechat.lechun.cc");
            connection.setConnectTimeout(9900);
            connection.setReadTimeout(9900);

            // 建立实际的连接
            connection.connect();
            // 获取所有响应头字段
            Map<String, List<String>> map = connection.getHeaderFields();
            // 遍历所有的响应头字段
            for (String key : map.keySet()) {
                System.out.println(key + "--->" + map.get(key));
            }
            // 定义 BufferedReader输入流来读取URL的响应
            in = new BufferedReader(new InputStreamReader(
                    connection.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            log.error("post参数"+url+"?"+param,e);
        }
        // 使用finally块来关闭输入流
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (Exception e2) {
                log.error("",e2);
            }
        }
        return result;
    }

    /**
     * 向指定 URL 发送POST方法的请求
     *
     * @param url   发送请求的 URL
     * @param param 请求参数，请求参数应该是 name1=value1&name2=value2 的形式。
     * @return 所代表远程资源的响应结果
     */
    public static String post(String url, String param) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            URL realUrl = new URL(url);
            // 打开和URL之间的连接
            URLConnection conn = realUrl.openConnection();
            // 设置通用的请求属性
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent",
                    "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setRequestProperty("referer", "http://wechat.lechun.cc");
            // 发送POST请求必须设置如下两行
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setConnectTimeout(1900);
            conn.setReadTimeout(1900);
            // 获取URLConnection对象对应的输出流
            out = new PrintWriter(conn.getOutputStream());
            // 发送请求参数
            out.print(param);
            // flush输出流的缓冲
            out.flush();
            // 定义BufferedReader输入流来读取URL的响应
            in = new BufferedReader(
                    new InputStreamReader(conn.getInputStream()));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            log.error("post参数"+url+"?"+param,e);
        }
        //使用finally块来关闭输出流、输入流
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            } catch (IOException ex) {
                log.error("",ex);
            }
        }
        return result;
    }
}
