package cc.lechun.framework.common.enums.pay;

import java.util.Arrays;
import java.util.List;

/**
 * Created by liqun on 2018/1/22.
 */
public enum PayStatusEnum {
    //0订单生成失败，1订单生成成功，2状态监测失败，3状态监测成功，4跳转支付失败，5跳转支付成功,6已支付成功
    ORDER_CREATE_FAIL(0, "orderFail"),
    ORDER_CREATE_SUCCESS(1, "orderCreateSuccess"),
    ORDER_CHECK_FAIL(2, "orderCheckFail"),
    ORDER_CHECK_SUCCESS(3,"orderCheckSuccess"),
    TO_PAY_FAIL(4,"toPayFail"),
    TO_PAY_SUCCESS(5,"toPaySuccess"),
    PAY_SUCCESS(6,"paySuccess");

    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<PayStatusEnum> getList() {
        return Arrays.asList(PayStatusEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        PayStatusEnum[] ls = PayStatusEnum.values();
        for (PayStatusEnum rs : ls) {
            if (rs.getValue()==value) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取名称
     */
    public static int getValue(String name) {
        PayStatusEnum[] ls = PayStatusEnum.values();
        for (PayStatusEnum rs : ls) {
            if (rs.getName().equals(name)) {
                return rs.getValue();
            }
        }
        return 0;
    }
    PayStatusEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "PayStatusEnum{" +
                "value='" + value + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
