package cc.lechun.framework.common.enums.quartz;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2017/12/13
 * Description: job分组
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum QuartzJobGroupEnum {

    DEFAULT_GROUP("DEFAULT", "默认分组"),
    EC_GROUP("ec_group", "商城分组"),
    OMS_GROUP("oms_group", "oms分组"),
    MARKET_GROUP("market_group", "营销活动"),
    PU_GROUP("pu_group", "采购分组"),
    WMS_GROUP("wms_group", "wms"),
    TMS_GROUP("tms_group", "tms"),
    BD_GROUP("db_group", "bd"),
    USER_GROUP("USER_group", "user"),
    SYS_GROUP("sys_group", "sys"),
    PAY_GROUP("pay_group", "pay"),
    ME_GROUP("me_group", "生产"),
    ORDER_GROUP("order_group", "订单分组"),
    ACTIVE_GROUP("active_group", "活动分组"),
    TEMPLATE_GROUP("template_group", "模板页面分组"),
    PROMOTION_GROUP("promotion_group", "促销分组"),
    ONCE_GROUP("once_group", "只执行一次分组");
    private String value;
    private String name;

    /**
     * 获取列表
     */
    public static List<QuartzJobGroupEnum> getList() {
        return Arrays.asList(QuartzJobGroupEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(String value) {
        QuartzJobGroupEnum[] ls = QuartzJobGroupEnum.values();
        for (QuartzJobGroupEnum rs : ls) {
            if (rs.getValue().equals(value)) {
                return rs.getName();
            }
        }
        return "";
    }
    /**
     * 通过value获取枚举对象
     */
    public static QuartzJobGroupEnum getQuartzJobGroupEnum(String value) {
        QuartzJobGroupEnum[] ls = QuartzJobGroupEnum.values();
        for (QuartzJobGroupEnum rs : ls) {
            if (rs.getValue().equals(value)) {
                return rs;
            }
        }
        return null;
    }

    QuartzJobGroupEnum(String value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

}
