package cc.lechun.framework.common.enums.sync;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Arrays;
import java.util.List;

/**
 * Created by wangxs on 2018/5/23
 * Description:
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum DataSyncTypeEnum {

    BI_MAIN_ORDER(1, "BI主订单同步"),
    BI_ORDER(2,"BI外部订单同步"),
    BI_CART(3,"BI购物车同步"),
    BI_COUPON(4,"BI优惠券同步");


    private int value;
    private String name;

    /**
     * 获取列表
     */
    public static List<DataSyncTypeEnum> getList() {
        return Arrays.asList(DataSyncTypeEnum.values());
    }

    /**
     * 通过value获取名称
     */
    public static String getName(int value) {
        DataSyncTypeEnum[] ls = DataSyncTypeEnum.values();
        for (DataSyncTypeEnum rs : ls) {
            if (rs.getValue() == value) {
                return rs.getName();
            }
        }
        return "";
    }

    DataSyncTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
