package cc.lechun.framework.common.utils.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * 配置文件读取
 */
public class Config {

    private final static Logger log = LoggerFactory.getLogger(Config.class);

    private static Map<String, Object> values = new HashMap<String, Object>();

    static {
        Properties p = new Properties();
        //File pFile = null;
        InputStream pInStream = null;
        try {
          /*  String path=Config.class.getClassLoader().getResource("application.properties").getPath();
            log.error("配置文件路径—"+path);*/
            //pFile = new File(path);
            pInStream = Config.class.getClassLoader().getResourceAsStream("application.properties");
            p.load(pInStream);
            Enumeration<String> enu = (Enumeration<String>) p.propertyNames();
            while (enu.hasMoreElements()) {
                String key = enu.nextElement();
                values.put(key, p.get(key));
            }
            log.info("配置文件加载完毕"+values.toString());
        } catch (Exception e) {
            log.error("加载配置文件失败", e);
        } finally {
            try {
                if (pInStream != null) {
                    pInStream.close();
                }
            } catch (IOException e) {
                log.error("加载配置文件失败", e);
            }
        }
    }

    /**
     * 获取数字类型
     */
    public static int intValue(String key) {
        return Integer.valueOf(values.get(key).toString());
    }

    /**
     * 获取值
     */
    public static String value(String key) {
        return values.get(key).toString();
    }

    /**
     * 获取值 如果是null 默认值
     */
    public static String value(String key, String def) {
        Object v = values.get(key);
        return v != null ? v.toString() : def;
    }
}
