package cc.lechun.framework.common.utils.sign;

import cc.lechun.framework.common.utils.http.HttpRequest;
import cc.lechun.framework.common.utils.json.JsonUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.SignatureException;
import java.util.*;

/**
 *  指定编码的MD5加密
 */
public class MD5 {
    private static final Logger logger = LoggerFactory.getLogger(MD5.class);

    /**
     * 签名字符串 默认UTF-8编码
     */
    public static String sign(String text) {
        return DigestUtils.md5Hex(text);
    }
    /**
     * 签名字符串 默认UTF-8编码
     */
    public static String sign(String text, String key) {
        text = text + key;
        return DigestUtils.md5Hex(text);
    }

    /**
     * 签名字符串
     * @param text 需要签名的字符串
     * @param key 密钥
     * @param input_charset 编码格式
     * @return 签名结果
     */
    public static String sign(String text, String key, String input_charset) {
        text = text + key;
        return DigestUtils.md5Hex(getContentBytes(text, input_charset));
    }

    /**
     * 签名字符串
     * @param text 需要签名的字符串
     * @param sign 签名结果
     * @param key 密钥
     * @param input_charset 编码格式
     * @return 签名结果
     */
    public static boolean verify(String text, String sign, String key, String input_charset) {
        text = text + key;
        String mysign = DigestUtils.md5Hex(getContentBytes(text, input_charset));
        if(mysign.equals(sign)) {
            return true;
        }
        else {
            return false;
        }
    }

    /**
     * @param content
     * @param charset
     * @return
     * @throws SignatureException
     * @throws UnsupportedEncodingException
     */
    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        } catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5签名过程中出现错误,指定的编码集不对,您目前指定的编码集是:" + charset);
        }
    }

    /**
     * 创建签名
     * @param paramsMap
     * @param apiKey
     * @return
     */
    public static String createSign(SortedMap<String, String> paramsMap,String apiKey) {
        StringBuffer sb = new StringBuffer();
        Set es = paramsMap.entrySet();
        Iterator it = es.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry) it.next();
            String k = (String) entry.getKey();
            String v = (String) entry.getValue();
            if (null != v && !"".equals(v) && !"sign".equals(k)
                    && !"key".equals(k)) {
                sb.append(k + ":" + v + ",");
            }
        }
        if(!sb.toString().isEmpty()){
            sb.deleteCharAt(sb.length()-1);
        }
        sb.append("_" + apiKey);
        logger.info("*********签名串**************sb={}", sb.toString());
        String sign = MD5.sign(sb.toString()).toUpperCase();
        logger.info("*********签名值**************sign={}", sign);
        return sign;

    }

    public static String signatureByAppKey(String paramString){
        try {
            Map<String, Object> params = JsonUtils.stringToMap(paramString);
            String appKey = params.get("appKey") == null ? "" : params.get("appKey").toString();
            return appKey;

        }catch (Exception e){
            logger.info("****************错误");
            return "错误";
        }
    }

    public static String md5(String text, String charset) throws Exception {
        if(charset == null || charset.length()==0)
            charset = "UTF-8";

        byte[] bytes = text.getBytes(charset);

        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(bytes);
        bytes = messageDigest.digest();

        StringBuilder sb = new StringBuilder();
        for(int i = 0; i < bytes.length; i ++)
        {
            if((bytes[i] & 0xff) < 0x10)
            {
                sb.append("0");
            }

            sb.append(Long.toString(bytes[i] & 0xff, 16));
        }

        return sb.toString().toLowerCase();
    }

    public static void main(String[] arg) {
        SortedMap<String, String> paramsMap = new TreeMap<String, String>();
        paramsMap.put("orderNo","201808131359513506442241");
        paramsMap.put("createTime","2018-11-08");
        paramsMap.put("appKey","key001");
        paramsMap.put("sign","32CE2EDF5E7A32B7F5AA41CA4642BF77");
        String paramString = JsonUtils.toJson(paramsMap,false);
        Map<String, Object> params = JsonUtils.stringToMap(paramString);

        String appKey = params.get("appKey") == null ? "" : params.get("appKey").toString();

        logger.info("appkey={},params={}",appKey,params.get("appKey"));
        String signUrl = null;
        signUrl = "http://registertest.lechun.cc:8802/lechun-sys/appToken/signatureByAppKey";
        String signResult = "";
        try {
            signResult = HttpRequest.post(signUrl,"paramString="+ URLEncoder.encode(paramString,"UTF-8"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        logger.info("********拦截器ApiInterceptor接口验签返回结果******signResult={}", signResult);
        System.out.println("=="+ MD5.sign("刘德华","","utf-8"));
        System.out.println("=="+ MD5.sign("刘德华",""));
    }
}
