package cc.lechun.framework.common.utils;

import org.apache.commons.lang.StringUtils;

/**
 * 反射的工具类
 */
public class ReflectUtil {

    /**
     * 根据 JavaBean属性名 获取 其 setter getter 方法
     *
     * @param fieldName
     * @param type      获取 get 还是 set 方法，请传入 "set" 或 "get"
     * @return
     */
    public static String getMethodName(String fieldName, String type) {
        String methodName = "";
        if (StringUtils.isBlank(fieldName) || StringUtils.isBlank(type)) {
            return methodName;
        }

        String start = "";
        if ("set".equals(type)) {
            start = "set";
        } else if ("get".equals(type)) {
            start = "get";
        }

        if (fieldName.length() == 1) {  //匹配类似 fieldName = "a" 或者  fieldName = "A"
            methodName = start + fieldName.toUpperCase();

        } else if (fieldName.substring(0, 1).matches("[a-z]") //匹配类似 fieldName = "aa..."
                && fieldName.substring(1, 2).matches("[a-z0-9$_]")) {
            methodName = start
                    + fieldName.substring(0, 1).toUpperCase()
                    + fieldName.substring(1);
        } else if ((fieldName.substring(0, 1).matches("[a-z]") //匹配类似 fieldName = "aA..." 或 fieldName = "AA..." 或 fieldName = "Aa..."
                && fieldName.substring(1, 2).matches("[A-Z0-9$_]"))
                || fieldName.substring(0, 1).matches("[A-Z]")) {
            methodName = start + fieldName;
        }
        return methodName;
    }
}
