package cc.lechun.framework.common.utils.serviceresult;

/**
 * <P>返回前端对象封装</P>
 * <p>User: monkey</p>
 * <p>Date&Time 2016-04-09 17:26.</p>
 */
public class Message {
    private boolean success = true;   // 状态 1-表示成功 0-表示失败
    private String msg = null;         // 前台返回信息（包括成功和失败信息），从ErrorConstant中取值
    private String code = null;        // 错误代码，从ErrorConstant取值
    private Object result = null;      // 前台返回实体对象

    public Message() {
    }

    public Message(boolean success, String msg) {
        this.success = success;
        this.msg = msg;
    }

    public Message(boolean success, String code, String msg) {
        this.success = success;
        this.msg = msg;
        this.code = code;
    }

    public Message(boolean success, String msg, Object result) {
        this.success = success;
        this.msg = msg;
        this.result = result;
    }

    public Message(boolean success, String code, String msg, Object result) {
        this.success = success;
        this.msg = msg;
        this.result = result;
        this.code = code;
    }

    /**
     * 请求失败返回的数据
     * @param code
     * @param msg
     * @param t
     * @return
     */
    public static <T> Message errorResp(String code, String msg, T t) {

        Message resp = new Message();
        resp.setSuccess(false);
        resp.setCode(code);
        resp.setMsg(msg);
        resp.setResult(t);
        return resp;
    }

    /**
     * 请求失败返回的数据
     * @return
     */
    public static <T> Message errorResp() {

        Message resp = new Message();
        resp.setSuccess(false);
        resp.setCode("1");
        resp.setMsg("failure");
        return resp;
    }

    /**
     * 请求失败返回的数据
     * @param msg
     * @return
     */
    public static <T> Message errorResp(String msg, T t) {

        Message resp = new Message();
        resp.setSuccess(false);
        resp.setCode("1");
        resp.setMsg(msg);
        resp.setResult(t);
        return resp;
    }
    /**
     * 请求失败返回的数据
     * @param msg
     * @return
     */
    public static <T> Message errorResp(String msg) {

        Message resp = new Message();
        resp.setSuccess(false);
        resp.setCode("1");
        resp.setMsg(msg);
        return resp;
    }

    /**
     * 请求成功返回的数据
     * @param msg
     * @param t
     * @return
     */
    public static <T> Message successResp(String msg,T t) {
        Message resp = new Message();
        resp.setSuccess(true);
        resp.setCode("0");
        resp.setMsg(msg);
        resp.setResult(t);
        return resp;
    }
    /**
     * 请求成功返回的数据
     * @param t
     * @return
     */
    public static <T> Message successResp(T t) {
        Message resp = new Message();
        resp.setSuccess(true);
        resp.setCode("0");
        resp.setMsg("success");
        resp.setResult(t);
        return resp;
    }
    /**
     * 请求成功返回的数据
     * @return
     */
    public static <T> Message successResp() {
        Message resp = new Message();
        resp.setSuccess(true);
        resp.setCode("0");
        resp.setMsg("success");
        return resp;
    }
    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public String toString() {
        return "Message [success=" + success + ", msg=" + msg + ", code=" + code
                + ", result=" + result + "]";
    }

}