/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.qrcode;

import cc.lechun.framework.common.utils.qrcode.MatrixToLogoImageConfig;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;

public class MatrixToImageWriterEx {
    private static final MatrixToLogoImageConfig DEFAULT_CONFIG = new MatrixToLogoImageConfig();

    public static BitMatrix createQRCode(String content, int width, int height, ErrorCorrectionLevel errorCorrectionLevel) {
        return MatrixToImageWriterEx.createQRCode(content, width, height, ErrorCorrectionLevel.H, 1);
    }

    public static BitMatrix createQRCode(String content, int width, int height, ErrorCorrectionLevel errorCorrectionLevel, int margin) {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, errorCorrectionLevel);
        hints.put(EncodeHintType.MARGIN, margin);
        BitMatrix matrix = null;
        try {
            matrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        return matrix;
    }

    public static BitMatrix createQRCode(String content, int width, int height) {
        return MatrixToImageWriterEx.createQRCode(content, width, height, ErrorCorrectionLevel.H);
    }

    public static void writeToFile(BitMatrix matrix, String format, String imagePath, String logoPath) throws IOException {
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(logoPath));
            MatrixToImageWriterEx.writeToFile(matrix, format, imagePath, input);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    public static void writeToFile(BitMatrix matrix, String format, String imagePath, InputStream logoInputStream) throws IOException {
        MatrixToImageWriter.writeToPath((BitMatrix)matrix, (String)format, (Path)new File(imagePath).toPath(), (MatrixToImageConfig)new MatrixToImageConfig());
        BufferedImage img = ImageIO.read(new File(imagePath));
        MatrixToImageWriterEx.overlapImage(img, format, imagePath, logoInputStream, DEFAULT_CONFIG);
    }

    public static void writeToFile(BitMatrix matrix, String format, String imagePath, InputStream logoPath, MatrixToLogoImageConfig logoConfig) throws IOException {
        MatrixToImageWriter.writeToPath((BitMatrix)matrix, (String)format, (Path)new File(imagePath).toPath(), (MatrixToImageConfig)new MatrixToImageConfig());
        BufferedImage img = ImageIO.read(new File(imagePath));
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                img.setRGB(x, y, matrix.get(x, y) ? -1 : -16777216);
            }
        }
        MatrixToImageWriterEx.overlapImage(img, format, imagePath, logoPath, logoConfig);
    }

    public static void overlapImage(BufferedImage image, String formate, String imagePath, InputStream logoInputStream, MatrixToLogoImageConfig logoConfig) {
        try {
            BufferedImage logo = ImageIO.read(logoInputStream);
            Graphics2D g = image.createGraphics();
            int width = image.getWidth() / logoConfig.getLogoPart();
            int height = image.getHeight() / logoConfig.getLogoPart();
            int x = (image.getWidth() - width) / 2;
            int y = (image.getHeight() - height) / 2;
            g.drawImage(logo, x, y, width, height, null);
            g.setStroke(new BasicStroke(logoConfig.getBorder()));
            g.setColor(logoConfig.getBorderColor());
            g.drawRect(x, y, width, height);
            g.dispose();
            ImageIO.write((RenderedImage)image, formate, new File(imagePath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

