/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.serviceresult;

import cc.lechun.framework.common.vo.BaseUser;
import cc.lechun.framework.common.vo.JedisUtils;
import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Resource;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogUtil {
    @Resource
    private HttpServletRequest request;

    public Object[] setLoggerContent(String remarks) {
        BaseUser user = null;
        String ip = null;
        try {
            user = JedisUtils.getBaseUser(this.request);
            ip = this.getIpAddr(this.request);
        }
        catch (Exception e) {
            ip = "127.0.0.1";
            e.printStackTrace();
        }
        String cTenantID = user != null ? user.getCtenantid() : "300846";
        String userName = user != null ? user.getEmployeeName() : "\u7cfb\u7edf\u7ba1\u7406\u5458";
        Object[] argArray = new Object[]{cTenantID, userName, ip, remarks};
        return argArray;
    }

    public String getColumn4() {
        return "URI:{},{},{},{}";
    }

    public Marker getQueryMarker() {
        return MarkerFactory.getMarker((String)"SQL");
    }

    private String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

