/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.web;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtils {
    private static final Logger log = LoggerFactory.getLogger(CookieUtils.class);

    public static void addCookie(HttpServletResponse response, String domain, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        if (!StringUtils.isEmpty((String)domain)) {
            cookie.setDomain(domain);
        }
        if (maxAge > 0) {
            cookie.setMaxAge(maxAge);
        }
        response.addCookie(cookie);
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        try {
            Map<String, Cookie> cookieMap = CookieUtils.ReadCookieMap(request);
            if (cookieMap.containsKey(name)) {
                Cookie cookie = cookieMap.get(name);
                return cookie;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void editCookie(HttpServletRequest request, HttpServletResponse response, String domain, String name, String value, int maxAge) {
        Cookie[] cookies = request.getCookies();
        if (null == cookies) {
            System.out.println("\u6ca1\u6709cookie==============");
        } else {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                cookie.setValue(value);
                cookie.setPath("/");
                cookie.setDomain(domain);
                cookie.setMaxAge(maxAge);
                response.addCookie(cookie);
                break;
            }
        }
    }

    public static void delCookie(HttpServletRequest request, HttpServletResponse response, String doMain, String name) {
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                cookie.setValue(null);
                cookie.setMaxAge(0);
                cookie.setPath("/");
                cookie.setDomain(doMain);
                response.addCookie(cookie);
                break;
            }
        }
    }

    public static Map<String, Cookie> ReadCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }
}

