/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.common.utils.log;

import cc.lechun.framework.common.utils.log.AccessLogEntity;
import cc.lechun.framework.common.utils.log.LoggerUtil;
import com.alibaba.fastjson.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LogInterceptor
implements HandlerInterceptor {
    private final Logger logger = LoggerFactory.getLogger((String)"accessmonitor");
    public static final String LOG_OPERATE = "lechun.api.log";

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) {
        AccessLogEntity log = LoggerUtil.getAccessLog(httpServletRequest);
        httpServletRequest.setAttribute(LOG_OPERATE, (Object)log);
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
        AccessLogEntity log = (AccessLogEntity)httpServletRequest.getAttribute(LOG_OPERATE);
        long endTime = System.currentTimeMillis();
        log.setEndTime(endTime);
        log.setRunTimes(endTime - log.getBeginTime());
        String json = JSON.toJSONString((Object)log, (boolean)false);
        this.logger.info(json);
    }
}

