/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gatewaynewserver.filter;

import cc.lechun.framework.gatewaynewserver.filter.CharacterGateway;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@Order(value=-1)
public class CharacterGateway
implements GlobalFilter {
    private static final Logger logger = LoggerFactory.getLogger(CharacterGateway.class);

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpResponse response = exchange.getResponse();
        response.getHeaders().add("Content-Type", "application/json;charset=UTF-8");
        Object cachedRequestBodyObject = exchange.getAttributeOrDefault("POST_BODY", null);
        String method = exchange.getRequest().getMethod().name();
        exchange.getAttributes().put("sysPath", exchange.getRequest().getPath().value().toLowerCase());
        if (exchange.getRequest().getHeaders().getContentType() == null || exchange.getRequest().getHeaders().getContentLength() == 0L) {
            return chain.filter(exchange);
        }
        if (cachedRequestBodyObject != null) {
            return chain.filter(exchange);
        }
        if (!HttpMethod.POST.matches(method.toUpperCase())) {
            return chain.filter(exchange);
        }
        return DataBufferUtils.join((Publisher)exchange.getRequest().getBody()).flatMap(dataBuffer -> {
            if (dataBuffer.readableByteCount() == 0) {
                return Mono.empty();
            }
            byte[] bytes = new byte[dataBuffer.readableByteCount()];
            dataBuffer.read(bytes);
            exchange.getAttributes().put("POST_BODY", new String(bytes, StandardCharsets.UTF_8));
            DataBufferUtils.release((DataBuffer)dataBuffer);
            Flux cachedFlux = Flux.defer(() -> {
                DataBuffer buffer = exchange.getResponse().bufferFactory().wrap(bytes);
                return Mono.just((Object)buffer);
            });
            1 mutatedRequest = new /* Unavailable Anonymous Inner Class!! */;
            return chain.filter(exchange.mutate().request((ServerHttpRequest)mutatedRequest).build());
        });
    }
}

