/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gatewaynewserver.util;

import cc.lechun.framework.gatewaynewserver.model.AccessLogEntity;
import cc.lechun.framework.gatewaynewserver.util.CookieUtilsGate;
import cc.lechun.framework.gatewaynewserver.util.IpUtilGate;
import cc.lechun.framework.gatewaynewserver.util.JsonUtilsGate;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class LoggerUtilGate {
    private static final Logger logger = LoggerFactory.getLogger(LoggerUtilGate.class);

    public static AccessLogEntity getAccessLog(ServerHttpRequest request) {
        AccessLogEntity log = new AccessLogEntity();
        try {
            HttpCookie cookie;
            String api = request.getURI().getPath().toString();
            String referer = request.getHeaders().getFirst("referer");
            String url = request.getURI().toString();
            String userAgent = request.getHeaders().getFirst("User-Agent");
            String params = JsonUtilsGate.toJson((Object)request.getQueryParams(), (boolean)false);
            String sign = (String)request.getQueryParams().getFirst((Object)"userTicket");
            String page = request.getHeaders().getFirst("Pagerouterurl");
            log.setIp(IpUtilGate.getCliectIp((ServerHttpRequest)request));
            log.setOperator("operator");
            log.setUserId("");
            log.setAction(api);
            String customerId = "";
            if (request != null && (cookie = CookieUtilsGate.getCookie((ServerHttpRequest)request, (String)"user")) != null) {
                customerId = URLDecoder.decode(cookie.getValue(), "utf-8");
            }
            log.setCustomerId(customerId);
            log.setMessage("\u63a5\u53e3\u76d1\u63a7");
            log.setReferer(referer);
            log.setBeginTime(Long.valueOf(System.currentTimeMillis()));
            log.setUrl(page);
            log.setUserAgent(userAgent);
            log.setParams(params);
            log.setSign(sign);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return log;
    }
}

