/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.framework.gateway.config;

import com.aliyun.openservices.aliyun.log.producer.LogProducer;
import com.aliyun.openservices.aliyun.log.producer.Producer;
import com.aliyun.openservices.aliyun.log.producer.ProducerConfig;
import com.aliyun.openservices.aliyun.log.producer.ProjectConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AliyunLogProducerConfig {
    @Value(value="${aliyun.sls.endpoint}")
    private String endpoint;
    @Value(value="${aliyun.sls.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.sls.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${aliyun.sls.project}")
    private String project;
    @Value(value="${aliyun.sls.logStore}")
    private String logStore;

    @Bean
    public Producer createProducer() {
        ProducerConfig producerConfig = new ProducerConfig();
        LogProducer producer = new LogProducer(producerConfig);
        producer.putProjectConfig(this.buildProjectConfig());
        return producer;
    }

    private ProjectConfig buildProjectConfig() {
        return new ProjectConfig(this.project, this.endpoint, this.accessKeyId, this.accessKeySecret);
    }
}

