/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.config;

import cc.lechun.common.apiInterceptor.ApiInterceptor;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.common.login.LoginInterceptor;
import cc.lechun.framework.common.utils.exception.MyExceptionHandler;
import cc.lechun.framework.common.utils.log.LogInterceptor;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ComponentScan(basePackages={"cc.lechun.*"})
@EnableWebMvc
public class ApiConfig
extends WebMvcConfigurerAdapter {
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"*.txt"}).addResourceLocations(new String[]{"classpath:/static/"});
        super.addResourceHandlers(registry);
    }

    @Bean
    public LogInterceptor logInterceptor() {
        return new LogInterceptor();
    }

    @Bean
    public LoginInterceptor loginInterceptor() {
        return new LoginInterceptor();
    }

    @Bean
    public ApiInterceptor apiInterceptor() {
        return new ApiInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.logInterceptor()).addPathPatterns(new String[]{"/**"});
        registry.addInterceptor((HandlerInterceptor)this.loginInterceptor()).addPathPatterns(new String[]{"/**"}).excludePathPatterns(new String[]{"/edb/**"}).excludePathPatterns(new String[]{"/eurekaChangeStatus"}).excludePathPatterns(new String[]{"/prepay/**"});
        registry.addInterceptor((HandlerInterceptor)this.apiInterceptor()).addPathPatterns(new String[]{"/edb/**"});
    }

    @Bean
    public MyExceptionHandler myExceptionHandler() {
        return new MyExceptionHandler();
    }

    public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        exceptionResolvers.add((HandlerExceptionResolver)this.myExceptionHandler());
    }

    @Bean
    public CustomerLoginService customerLoginService() {
        return new CustomerLoginService();
    }
}

