/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.prepay;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"prepay"})
public class PrepayController {
    @Autowired
    private PrepayCardPlanDetailInterface planDetailInterface;
    @Autowired
    private PrepayCardOrderPlanInterface prepayCardOrderPlanService;
    @Autowired
    private CustomerLoginService customerLoginService;

    @RequestMapping(value={"createPlanOrder"})
    public BaseJsonVo createPlanOrder() throws InvalidKeySpecException, NoSuchAlgorithmException {
        this.planDetailInterface.createPlanOrder(DateUtils.currentDate());
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getOrderPlanList"})
    public BaseJsonVo getOrderPlanList(String orderMainNo) {
        return this.prepayCardOrderPlanService.getOrderPlanList(orderMainNo);
    }

    @RequestMapping(value={"refundOrderPlan"})
    public BaseJsonVo refundOrderPlan(String orderMainNo, Integer orderSource, String planIds, BigDecimal amount, String operator) {
        return this.prepayCardOrderPlanService.refundOrderPlan(orderMainNo, orderSource.intValue(), planIds, amount, operator);
    }

    @RequestMapping(value={"getMyCardList"})
    public BaseJsonVo getMyCardList() throws InvalidKeySpecException, NoSuchAlgorithmException, AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getMyCardList(customerDetailVo.getCustomerId()));
    }

    @RequestMapping(value={"getFirstDeliveryDate"})
    public BaseJsonVo getFirstDeliveryDate(int periodType, Integer period) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getFirstDeliveryDate(periodType, period));
    }

    @RequestMapping(value={"saveDeliveryRule"})
    public BaseJsonVo saveDeliveryRule(PrepayCardEntity prepayCardEntity) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return this.prepayCardOrderPlanService.saveDeliverRule(prepayCardEntity);
    }

    @RequestMapping(value={"suspendDeliveryPlan"})
    public BaseJsonVo suspendDeliveryPlan(String cardId) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return this.prepayCardOrderPlanService.suspendDeliveryPlan(cardId);
    }

    @RequestMapping(value={"getCardPlanDetail"})
    public BaseJsonVo getCardPlanDetail(String cardId) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return this.prepayCardOrderPlanService.getCardPlanDetail(cardId);
    }
}

