/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.prepay;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.prepay.PrepayCardDo;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import com.github.pagehelper.util.StringUtil;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"prepay"})
public class PrepayController {
    @Autowired
    private PrepayCardPlanDetailInterface planDetailInterface;
    @Autowired
    private PrepayCardOrderPlanInterface prepayCardOrderPlanService;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private PrepayCardInterface cardInterface;

    @RequestMapping(value={"createPlanOrder"})
    public BaseJsonVo createPlanOrder(String date) throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (StringUtil.isEmpty((String)date)) {
            this.planDetailInterface.createPlanOrder(DateUtils.currentDate());
        } else {
            this.planDetailInterface.createPlanOrder(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getOrderPlanList"})
    public BaseJsonVo getOrderPlanList(String orderMainNo) {
        return this.prepayCardOrderPlanService.getOrderPlanList(orderMainNo);
    }

    @RequestMapping(value={"getCardInfo"})
    public BaseJsonVo getCardInfo(String orderMainNo) {
        return this.prepayCardOrderPlanService.getCardInfo(orderMainNo);
    }

    @RequestMapping(value={"refundOrderPlan"})
    public BaseJsonVo refundOrderPlan(String orderMainNo, Integer orderSource, String planIds, BigDecimal amount, String operator) {
        return this.prepayCardOrderPlanService.refundOrderPlan(orderMainNo, orderSource.intValue(), planIds, amount, operator);
    }

    @RequestMapping(value={"getMyCardList"})
    public BaseJsonVo getMyCardList() throws InvalidKeySpecException, NoSuchAlgorithmException, AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getMyCardList(customerDetailVo.getCustomerId()));
    }

    @RequestMapping(value={"getFirstDeliveryDate"})
    public BaseJsonVo getFirstDeliveryDate(PrepayCardEntity prepayCardEntity) throws InvalidKeySpecException, NoSuchAlgorithmException, AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        prepayCardEntity.setBelongCustomerId(customerDetailVo.getCustomerId());
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getFirstDeliveryDate(prepayCardEntity.getPeriodType().intValue(), prepayCardEntity.getPeriod()));
    }

    @RequestMapping(value={"saveOrderPlanDetailed"})
    public BaseJsonVo saveOrderPlanDetailed(PrepayCardDo prepayCardDo) throws InvalidKeySpecException, NoSuchAlgorithmException, AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        return this.prepayCardOrderPlanService.saveOrderPlan(prepayCardDo, customerDetailVo.getCustomerId());
    }

    @RequestMapping(value={"deleteOrderPlan"})
    public BaseJsonVo deleteOrderPlan(Integer detailedId) throws InvalidKeySpecException, NoSuchAlgorithmException, AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        return this.prepayCardOrderPlanService.deleteOrderPlan(detailedId, customerDetailVo.getCustomerId());
    }

    @RequestMapping(value={"createPlanOrderTest"})
    public BaseJsonVo createPlanOrder_test(String cardId) {
        return this.planDetailInterface.createPlanOrder(cardId);
    }

    @RequestMapping(value={"saveDeliveryRule"})
    public BaseJsonVo saveDeliveryRule(PrepayCardDo prepayCardDo) throws InvalidKeySpecException, NoSuchAlgorithmException, AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        PrepayCardEntity prepayCardEntity = new PrepayCardEntity();
        BeanUtils.copyProperties((Object)prepayCardDo, (Object)prepayCardEntity);
        BaseJsonVo baseJsonVo = this.prepayCardOrderPlanService.saveDeliverRule(prepayCardDo);
        if (baseJsonVo.isSuccess()) {
            this.planDetailInterface.createPlanOrder(prepayCardDo.getCardId());
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"suspendDeliveryPlan"})
    public BaseJsonVo suspendDeliveryPlan(String cardId) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return this.prepayCardOrderPlanService.suspendDeliveryPlan(cardId);
    }

    @RequestMapping(value={"getCardPlanDetail"})
    public BaseJsonVo getCardPlanDetail(String cardId) throws InvalidKeySpecException, NoSuchAlgorithmException, AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        return this.prepayCardOrderPlanService.getCardPlanDetail(cardId);
    }

    @RequestMapping(value={"test112"})
    public BaseJsonVo orderPaySuccessUpdateCardPlanStatus(Integer num, String cardId) {
        for (int i = 0; i < num; ++i) {
            this.planDetailInterface.createPlanOrder(cardId);
        }
        return BaseJsonVo.success((Object)"");
    }
}

