/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.reserve;

import cc.lechun.active.iservice.reserve.ReserveInterface;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reserve"})
public class ReserveController {
    @Autowired
    private ReserveInterface reserveService;
    @Autowired
    private CustomerLoginService customerLoginService;

    @RequestMapping(value={"reserve"})
    public BaseJsonVo reserve(@RequestParam(value="aliasId") String aliasId, @RequestParam(value="type") String type) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reserveService.reserve(customer.getCustomerId(), aliasId, type);
    }

    @RequestMapping(value={"getReserve"})
    public BaseJsonVo getReserve(String aliasId) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reserveService.getReserve(customer.getCustomerId(), aliasId);
    }

    @RequestMapping(value={"getReserveCount"})
    public BaseJsonVo getReserveCount(String alias) {
        return this.reserveService.getActiveReserve(alias);
    }
}

