/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.groupon;

import cc.lechun.active.entity.groupon.GrouponConfigEntity;
import cc.lechun.active.entity.groupon.GrouponEntity;
import cc.lechun.active.entity.groupon.GrouponOrder;
import cc.lechun.active.entity.groupon.GrouponOrderVo;
import cc.lechun.active.iservice.groupon.GrouponInterface;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/groupon"})
public class GrouponController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private GrouponInterface grouponService;
    @Autowired
    private MallOrderMainInterface mallOrderMainService;
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    protected MallOrderInterface mallOrderInterface;

    @RequestMapping(value={"/getGrouponByOrderNo"})
    public BaseJsonVo getGrouponOrder(String orderMainNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        GrouponOrder grouponOrder = this.grouponService.getGrouponOrderByOrderNo(orderMainNo);
        GrouponEntity grouponEntity = this.grouponService.getGrouponInfoByInviteId(grouponOrder.getInviteId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("qUrl", customerDetailVo.getHeadImageUrl());
        map.put("nickName", customerDetailVo.getNickName());
        map.put("source", grouponEntity.getCustomerId());
        Integer num = grouponEntity.getJoinNum();
        map.put("only", num - grouponEntity.getInviteCount());
        map.put("num", num);
        map.put("inviteId", grouponOrder.getInviteId());
        map.put("startTime", grouponEntity.getCreateTime());
        map.put("seconds", DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)grouponEntity.getEndTime()));
        map.put("type", grouponOrder.getOrderType());
        map.put("proName", this.grouponService.getProductName(orderMainNo));
        map.put("deliverTime", "");
        map.put("list", this.grouponService.getJoinOrderVoList(grouponEntity.getInviteId()));
        baseJsonVo.setValue(map);
        baseJsonVo.setStatus(200);
        return baseJsonVo;
    }

    @RequestMapping(value={"/checkJoinGroupon"})
    public BaseJsonVo checkCanJoin(String bindCode, String inviteId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.grouponService.checkCanJoin(bindCode, customerDetailVo.getCustomerId(), inviteId);
    }

    @RequestMapping(value={"/getGrouponList"})
    public BaseJsonVo getGrouponList(String bindCode, Integer num) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        HashMap<String, Object> map = new HashMap<String, Object>();
        GrouponConfigEntity configEntity = this.grouponService.getGrouponConfigByBindCode(bindCode);
        map.put("config", configEntity);
        if (configEntity.getIsShow() == 1) {
            map.put("startList", this.grouponService.getGrouponList(bindCode, num));
        } else {
            map.put("startList", "");
        }
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/getSuccessGrouponList"})
    public BaseJsonVo getSuccessGrouponList(String bindCode, Integer num) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.grouponService.getSuccessGrouponList(bindCode, num, customerDetailVo.getPlatformId()));
    }

    @RequestMapping(value={"/getGrouponConfig"})
    public BaseJsonVo getGrouponConfig(String bindCode) {
        return BaseJsonVo.success((Object)this.grouponService.getGrouponConfigByBindCode(bindCode));
    }

    @RequestMapping(value={"/Test"})
    public BaseJsonVo Test(int platFormId, String orderMainNo) {
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        GrouponOrder grouponOrder = this.grouponService.getGrouponOrderByOrderNo(orderMainNo);
        GrouponOrderVo grouponOrderVo = new GrouponOrderVo();
        grouponOrderVo.setOrderMainNo(orderMainNo);
        grouponOrderVo.setCustomerId(grouponOrder.getCustomerId());
        grouponOrderVo.setPlatFormId(Integer.valueOf(1));
        grouponOrderVo.setStatus(Integer.valueOf(OrderStatusEnum.UNCONFIRM.getValue()));
        grouponOrderVo.setBindCode("6a3feb5e78f6431fbeeaecb5be5ed101");
        grouponOrderVo.setPrice(new BigDecimal(6));
        grouponOrderVo.setOnly(Integer.valueOf(2));
        String inviteId = grouponOrder.getInviteId();
        grouponOrderVo.setInviteId(inviteId);
        this.grouponService.saveGrouponOrder(grouponOrderVo);
        return baseJsonVo;
    }

    @RequestMapping(value={"/cashticketTest"})
    public BaseJsonVo cashticketTest() {
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/testrefund"})
    public BaseJsonVo testrefund(String activeNo) {
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        orderMainEntity.setActiveNo(activeNo);
        List allList = this.mallOrderMainService.getOrderMainList(orderMainEntity);
        this.logger.info("\u67e5\u8be2\u5230\u7684\u8ba2\u5355\u6709:" + allList.size());
        List unrefundList = allList.stream().filter(o -> o.getStatus() >= 2 && o.getStatus() < 20).collect(Collectors.toList());
        this.logger.info("\u7b26\u5408\u9000\u6b3e\u6761\u4ef6\u7684\u8ba2\u5355:" + unrefundList.size());
        ExecutorService pool = Executors.newFixedThreadPool(1);
        pool.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        pool.shutdown();
        return BaseJsonVo.success((Object)"\u9000\u6b3e\u4e2d...\u8bf7\u4e0d\u8981\u91cd\u590d\u6253\u5f00\u8fde\u63a5...");
    }

    @RequestMapping(value={"/testrefund1"})
    public BaseJsonVo testrefund1(String activeNo) {
        MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
        orderMainEntity.setActiveNo(activeNo);
        List allList = this.mallOrderMainService.getOrderMainList(orderMainEntity);
        this.logger.info("\u67e5\u8be2\u5230\u7684\u8ba2\u5355\u6709:" + allList.size());
        List unrefundList = allList.stream().filter(o -> o.getStatus() >= 2 && o.getStatus() < 20).collect(Collectors.toList());
        this.logger.info("\u7b26\u5408\u9000\u6b3e\u6761\u4ef6\u7684\u8ba2\u5355:" + unrefundList.size());
        ExecutorService pool = Executors.newFixedThreadPool(1);
        pool.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        pool.shutdown();
        return BaseJsonVo.success((Object)"\u9000\u6b3e\u4e2d...\u8bf7\u4e0d\u8981\u91cd\u590d\u6253\u5f00\u8fde\u63a5...");
    }

    static /* synthetic */ PayOrderInterface access$000(GrouponController x0) {
        return x0.payOrderInterface;
    }
}

