/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.customer;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.common.enums.customer.MobileValidateTypeEnum;
import cc.lechun.common.enums.customer.PasswordTypeEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.common.vo.weixin.mini.MiniProgramUserVo;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.sign.AESUtil;
import cc.lechun.framework.common.utils.sign.AESUtil2;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.utils.web.RequestDetail;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerCentreVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.customer.CustomerIdslVo;
import cc.lechun.mall.entity.customer.CustomerInfoDetailEntity;
import cc.lechun.mall.entity.customer.CustomerInfoVo;
import cc.lechun.mall.entity.customer.CustomerMobilePassWordVo;
import cc.lechun.mall.entity.customer.CustomerSafeQuestionEntity;
import cc.lechun.mall.entity.customer.CustomerSafeQuestionVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.vip.MallVipVo;
import cc.lechun.mall.entity.weixin.WeiXinBaseEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerInfoDetailInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerMobileInterface;
import cc.lechun.mall.iservice.customer.CustomerSafeQuestionInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormGroupInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import weixin.popular.api.SnsAPI;
import weixin.popular.api.UserAPI;
import weixin.popular.bean.sns.Jscode2sessionResult;
import weixin.popular.bean.sns.SnsToken;
import weixin.popular.bean.user.User;

@Controller
@RequestMapping(value={"/customer"})
public class CustomerController {
    private static final Logger log = LoggerFactory.getLogger(CustomerController.class);
    @Autowired
    private WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    private CustomerMobileInterface customerMobileInterface;
    @Autowired
    private CustomerInfoDetailInterface customerInfoDetailInterface;
    @Autowired
    private CustomerSafeQuestionInterface customerSafeQuestionInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MallTradeInterface mallTradeInterface;
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private AccountBalanceInterface accountBalanceInterface;
    @Autowired
    private PlatFormGroupInterface platFormGroupInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private MallVipInterface vipService;
    @Autowired
    private BalanceAccountInvoke balanceApi;
    @Value(value="${wxrollbackUrl:lechun-mall/customer/getWechatauthor}")
    private String wxrollbackUrl;

    @RequestMapping(value={"/wechatauthor"})
    @ResponseBody
    public BaseJsonVo wechatauthor(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        String page_redictUrl = request.getParameter("redict_url");
        String state = request.getParameter("state");
        String scope = "snsapi_base";
        scope = RequestDetail.getRequestString((HttpServletRequest)request, (String)"scope", (String)"snsapi_base");
        boolean flag = false;
        if (scope.equals("snsapi_userinfo")) {
            flag = true;
        }
        if (StringUtils.isEmpty((String)page_redictUrl)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        int platformId = this.customerLoginService.getPlatFormId();
        WeiXinBaseEntity weiXinBase = this.weiXinBaseInterface.getWeixinBaseByFlatformId(Integer.valueOf(platformId));
        PlatFormEntity platFormEntity = this.platFormInterface.getPlatForm(this.customerLoginService.getPlatFormId());
        String service_url = platFormEntity.getDomainServer() + this.wxrollbackUrl + "?scope=" + scope + "&" + "platformIdKey" + "=" + platformId + "&redict_url=" + URLEncoder.encode(page_redictUrl, "UTF-8");
        String url = SnsAPI.connectOauth2Authorize((String)(weiXinBase == null ? "123" : weiXinBase.getAppid()), (String)service_url, (boolean)flag, (String)state);
        return BaseJsonVo.success((Object)url);
    }

    @RequestMapping(value={"/getWechatauthor"})
    public void getWechatauthor(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String page_redictUrl = request.getParameter("redict_url");
        String return_params = "success=0";
        String params = "";
        try {
            String code = request.getParameter("code");
            String state = request.getParameter("state");
            if (StringUtils.isEmpty((String)code)) {
                return;
            }
            String scope = request.getParameter("scope");
            int platformId = this.customerLoginService.getPlatFormId();
            WeiXinBaseEntity weiXinBase = this.weiXinBaseInterface.getWeixinBaseByFlatformId(Integer.valueOf(platformId));
            SnsToken snsToken = SnsAPI.oauth2AccessToken((String)weiXinBase.getAppid(), (String)weiXinBase.getAppscret(), (String)code);
            if (snsToken.isSuccess()) {
                BaseJsonVo vo;
                User user = null;
                if (scope.equals("snsapi_base")) {
                    if (StringUtils.isEmpty((String)snsToken.getUnionid())) {
                        user = UserAPI.userInfo((String)weiXinBase.getAccessToken(), (String)snsToken.getOpenid());
                    }
                } else {
                    user = SnsAPI.userinfo((String)snsToken.getAccess_token(), (String)snsToken.getOpenid(), (String)"zh_CN");
                    String userName = URLEncoder.encode(user.getNickname(), "UTF-8");
                    String headimgurl = user.getHeadimgurl();
                    params = "&state=" + state + "&nickname=" + userName + "&sex=" + headimgurl + "&headimgurl=" + headimgurl;
                }
                if ((vo = this.customerInterface.addCustomer4Wechat(platformId, snsToken.getOpenid(), snsToken.getUnionid(), "", "", user, "", "")).isSuccess()) {
                    CustomerEntity customerEntity = (CustomerEntity)vo.getValue();
                    this.customerLoginService.login(response, request, customerEntity.getSign());
                    return_params = "success=1";
                }
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        if (!StringUtils.isEmpty((String)params)) {
            page_redictUrl = page_redictUrl + (page_redictUrl.indexOf("?") > -1 ? "&" : "?") + return_params + params;
        }
        response.sendRedirect(page_redictUrl);
    }

    @RequestMapping(value={"/miniProgramLogin"})
    @ResponseBody
    public BaseJsonVo miniProgramLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String iv;
        String encryptedData;
        String signature;
        String code = request.getParameter("code");
        if (StringUtils.isEmpty((String)code)) {
            BaseJsonVo.paramError((String)"code\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)(signature = request.getParameter("signature")))) {
            BaseJsonVo.paramError((String)"signature\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)(encryptedData = request.getParameter("encryptedData")))) {
            BaseJsonVo.paramError((String)"encryptedData\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)(iv = request.getParameter("iv")))) {
            BaseJsonVo.paramError((String)"iv\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int platformId = this.customerLoginService.getPlatFormId();
        log.info("************miniProgramLogin\u5c0f\u7a0b\u5e8f\u5e73\u53f0\u6807\u793a************platformId={}", (Object)platformId);
        WeiXinBaseEntity weiXinBase = this.weiXinBaseInterface.getWeixinBaseByFlatformId(Integer.valueOf(platformId));
        Jscode2sessionResult jscode2sessionResult = SnsAPI.jscode2session((String)weiXinBase.getAppid(), (String)weiXinBase.getAppscret(), (String)code);
        if (jscode2sessionResult.isSuccess()) {
            String userInfo = this.decodeUserInfo(encryptedData, jscode2sessionResult.getSession_key(), iv);
            MiniProgramUserVo user = (MiniProgramUserVo)JSON.parseObject((String)userInfo, MiniProgramUserVo.class);
            BaseJsonVo vo = this.customerInterface.addCustomer4Wechat(platformId, user.getOpenId(), user.getUnionId(), user.getNickName(), "", user.toUser(), "", "");
            if (vo.isSuccess()) {
                CustomerEntity customerEntity = (CustomerEntity)vo.getValue();
                return BaseJsonVo.success((Object)customerEntity.getSign());
            }
            return BaseJsonVo.paramError((String)vo.getMessage());
        }
        return new BaseJsonVo(500, jscode2sessionResult.getErrmsg());
    }

    @RequestMapping(value={"/sendMobileValidateCode"})
    @ResponseBody
    public BaseJsonVo sendMobileValidateCode(HttpServletRequest request, HttpServletResponse response, String validateCodeType, String mobile) throws AuthorizeException {
        if (StringUtils.isEmpty((String)validateCodeType)) {
            return BaseJsonVo.paramError((String)"\u9a8c\u8bc1\u7c7b\u578b\u9519\u8bef");
        }
        if (this.memcachedService.isExceedCount("mobileValidateCode", "sendMobileValidateCode", 300, 60)) {
            return BaseJsonVo.error((String)"\u963f\u5076\uff01\u6b47\u6b47\u5427\uff0c\u4e0d\u8981\u7d2f\u5012\u5566~~~");
        }
        String ip = IpUtil.getCliectIp((HttpServletRequest)request);
        if (this.memcachedService.isExceedCount("mobileValidateCode", ip, 5, 60)) {
            return BaseJsonVo.error((String)"\u963f\u5076\uff01\u6b47\u6b47\u5427\uff0c\u4e0d\u8981\u7d2f\u5012\u5566~~~");
        }
        CustomerDetailVo customerDetailVo = null;
        if (!validateCodeType.equals(MobileValidateTypeEnum.login.name())) {
            customerDetailVo = this.customerLoginService.getCustomer(true);
            String string = mobile = StringUtils.isEmpty((String)mobile) ? customerDetailVo.getMobile() : mobile;
            if (validateCodeType.equals(MobileValidateTypeEnum.validateMobile.name()) && StringUtils.isEmpty((String)mobile)) {
                return BaseJsonVo.paramError((String)"\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u65e0\u6cd5\u9a8c\u8bc1");
            }
        }
        if (StringUtils.isEmpty((String)mobile) || mobile.length() != 11 || !mobile.startsWith("1")) {
            return BaseJsonVo.paramError((String)"\u624b\u673a\u53f7\u7801\u4e0d\u6b63\u786e");
        }
        if (this.memcachedService.isExceedCount("mobileValidateCode", validateCodeType + "_" + mobile, 1, 60)) {
            return BaseJsonVo.error((String)"\u83b7\u53d6\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.customerMobileInterface.sendValidateCode(validateCodeType, mobile, customerDetailVo == null ? "" : customerDetailVo.getCustomerId());
        return BaseJsonVo.success((Object)"\u53d1\u9001\u6210\u529f");
    }

    @RequestMapping(value={"/validateMobileOrSafe"})
    @ResponseBody
    public BaseJsonVo validateMobileOrSafe(HttpServletRequest request, HttpServletResponse response, String validateCode, Integer type) throws AuthorizeException {
        if (type == null) {
            type = 1;
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.validateMobileOrSafe(customerDetailVo, validateCode, type);
    }

    private BaseJsonVo validateMobileOrSafe(CustomerDetailVo customerDetailVo, String validateCode, Integer type) {
        if (StringUtils.isEmpty((String)validateCode)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u7b54\u6848");
        }
        if (type == 1) {
            if (customerDetailVo == null || StringUtils.isEmpty((String)customerDetailVo.getMobile())) {
                return BaseJsonVo.paramError((String)"\u6ca1\u6709\u7ed1\u5b9a\u7535\u8bdd");
            }
            boolean flag = this.customerMobileInterface.validateCode(MobileValidateTypeEnum.validateMobile.name(), customerDetailVo.getMobile(), validateCode);
            if (flag) {
                return BaseJsonVo.success((Object)"\u9a8c\u8bc1\u6210\u529f");
            }
            flag = this.customerMobileInterface.validateCode(MobileValidateTypeEnum.bindMobile.name(), customerDetailVo.getMobile(), validateCode);
            if (flag) {
                return BaseJsonVo.success((Object)"\u9a8c\u8bc1\u6210\u529f");
            }
            return BaseJsonVo.paramError((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        if (type == 2) {
            List ls = this.customerSafeQuestionInterface.getCustomerSafeQuestion(customerDetailVo.getCustomerId());
            if (ls == null || ls.size() == 0) {
                return BaseJsonVo.paramError((String)"\u6ca1\u6709\u7ed1\u5b9a\u5bc6\u4fdd");
            }
            CustomerSafeQuestionEntity customerSafeQuestionEntity = (CustomerSafeQuestionEntity)ls.get(0);
            if (validateCode.trim().equals(customerSafeQuestionEntity.getAnswer().trim())) {
                return BaseJsonVo.success((Object)"\u9a8c\u8bc1\u6210\u529f");
            }
            return BaseJsonVo.paramError((String)"\u5bc6\u4fdd\u56de\u7b54\u9519\u8bef");
        }
        return BaseJsonVo.paramError((String)"\u9a8c\u8bc1\u7c7b\u578b\u9519\u8bef");
    }

    @RequestMapping(value={"/webLogin"})
    @ResponseBody
    public BaseJsonVo webLogin(HttpServletRequest request, HttpServletResponse response, String mobile, String validateCode, String bindCode, String versionDetailId) throws IOException {
        if (StringUtils.isEmpty((String)mobile) || mobile.length() != 11 || !mobile.startsWith("1")) {
            return BaseJsonVo.paramError((String)"\u624b\u673a\u53f7\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)validateCode)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
        }
        if (!this.customerMobileInterface.validateCode(MobileValidateTypeEnum.login.name(), mobile, validateCode)) {
            return BaseJsonVo.paramError((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        int platformId = this.customerLoginService.getPlatFormId();
        BaseJsonVo vo = this.customerInterface.addCustomer4Mobile(platformId, mobile, bindCode, versionDetailId);
        if (!vo.isSuccess()) {
            return BaseJsonVo.error((String)"\u767b\u5f55\u5931\u8d25");
        }
        CustomerEntity customerEntity = (CustomerEntity)vo.getValue();
        this.customerLoginService.login(response, request, customerEntity.getSign());
        return BaseJsonVo.success((Object)"\u767b\u5f55\u6210\u529f");
    }

    @RequestMapping(value={"/bindMobile"})
    @ResponseBody
    public BaseJsonVo bindMobile(HttpServletRequest request, HttpServletResponse response, String mobile, String validateCode, String safeQuestion) throws IOException, AuthorizeException {
        if (!StringUtils.isEmpty((String)safeQuestion.trim())) {
            safeQuestion = URLDecoder.decode(safeQuestion, "UTF-8");
        }
        if (StringUtils.isEmpty((String)mobile) || mobile.length() != 11 || !mobile.startsWith("1")) {
            return BaseJsonVo.paramError((String)"\u624b\u673a\u53f7\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)validateCode)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
        }
        if (!this.customerMobileInterface.validateCode(MobileValidateTypeEnum.bindMobile.name(), mobile, validateCode)) {
            return BaseJsonVo.paramError((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.customerInterface.bindMobile(mobile, customerDetailVo.getCustomerId(), safeQuestion);
    }

    @RequestMapping(value={"/updateMobile"})
    @ResponseBody
    public BaseJsonVo updateMobile(HttpServletRequest request, HttpServletResponse response, String mobile, String validateCode) throws IOException, AuthorizeException {
        if (StringUtils.isEmpty((String)mobile) || mobile.length() != 11 || !mobile.startsWith("1")) {
            return BaseJsonVo.paramError((String)"\u624b\u673a\u53f7\u9519\u8bef");
        }
        if (StringUtils.isEmpty((String)validateCode)) {
            return BaseJsonVo.paramError((String)"\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
        }
        if (!this.customerMobileInterface.validateCode(MobileValidateTypeEnum.updateMobile.name(), mobile, validateCode)) {
            return BaseJsonVo.paramError((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.customerInterface.bindMobile(mobile, customerDetailVo.getCustomerId(), "");
    }

    @RequestMapping(value={"/updatePayPassword"})
    @ResponseBody
    public BaseJsonVo updatePayPassword(HttpServletRequest request, HttpServletResponse response, String validateCode, Integer type, String password) throws AuthorizeException, InvalidKeySpecException, NoSuchAlgorithmException {
        log.info("\u8fdb\u5165updatePayPassword,\u53c2\u6570\uff1avalidateCode\uff1a" + validateCode + ",type:" + type + ",password:" + password);
        if (StringUtils.isEmpty((String)password.trim())) {
            return BaseJsonVo.paramError((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        log.info("\u8fdb\u5165updatePayPassword,customerDetailVo\uff1a" + JsonUtils.toJson((Object)customerDetailVo, (boolean)false));
        BaseJsonVo rs = this.validateMobileOrSafe(customerDetailVo, validateCode, type);
        log.info("\u8fdb\u5165updatePayPassword,validateMobileOrSafe\u8fd4\u56de\uff1a" + JsonUtils.toJson((Object)rs, (boolean)false));
        if (rs.isSuccess()) {
            return this.customerInterface.updatePassword(customerDetailVo.getCustomerId(), password, PasswordTypeEnum.pay_password);
        }
        return rs;
    }

    @RequestMapping(value={"/getCustomerMobilePassWord"})
    @ResponseBody
    public BaseJsonVo getCustomerMobilePassWord(HttpServletRequest request, HttpServletResponse response) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.getCustomerMobilePassWord(customerDetailVo));
    }

    private CustomerMobilePassWordVo getCustomerMobilePassWord(CustomerDetailVo customerDetailVo) {
        CustomerEntity customerEntity = this.customerInterface.getCustomer(customerDetailVo.getCustomerId());
        List ls = this.customerSafeQuestionInterface.getCustomerSafeQuestion(customerDetailVo.getCustomerId());
        CustomerMobilePassWordVo vo = new CustomerMobilePassWordVo();
        vo.setNickName(customerDetailVo.getNickName());
        vo.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
        vo.setMobile(StringUtils.rePlacePhone((String)customerDetailVo.getMobile()));
        vo.setBindMobile(customerDetailVo.getMobile() == null || StringUtils.isEmpty((String)customerDetailVo.getMobile().trim()) ? 0 : 1);
        vo.setBindPayPassWord(StringUtils.isEmpty((String)customerEntity.getPayPassword()) ? 0 : 1);
        vo.setBindSafeQuestion(ls == null || ls.size() == 0 ? 0 : 1);
        List safeQuestion = ls.stream().map(customerSafeQuestionEntity -> {
            CustomerSafeQuestionVo customerSafeQuestionVo = new CustomerSafeQuestionVo();
            customerSafeQuestionVo.setSafeQuestionId(customerSafeQuestionEntity.getSafeQuestionId());
            customerSafeQuestionVo.setSafeQuestionName(customerSafeQuestionEntity.getSafeQuestionName());
            return customerSafeQuestionVo;
        }).collect(Collectors.toList());
        vo.setSafeQuestion(safeQuestion);
        return vo;
    }

    @RequestMapping(value={"/getCustomerDetail"})
    @ResponseBody
    public BaseJsonVo getCustomerDetail(HttpServletRequest request, HttpServletResponse response) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        customerDetailVo.setMobile(StringUtils.rePlacePhone((String)customerDetailVo.getMobile()));
        return BaseJsonVo.success((Object)customerDetailVo);
    }

    @RequestMapping(value={"/getCustomerInfo"})
    @ResponseBody
    public BaseJsonVo getCustomerInfo(HttpServletRequest request, HttpServletResponse response) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        CustomerInfoDetailEntity customerInfoDetailEntity = this.customerInfoDetailInterface.getCustomerInfoDetail(customerDetailVo.getCustomerId());
        CustomerInfoVo customerInfoVo = new CustomerInfoVo();
        customerInfoVo.setCustomerDetail(customerInfoDetailEntity);
        customerInfoVo.setCustomerInfo(this.getCustomerMobilePassWord(customerDetailVo));
        BaseJsonVo userBalance = this.balanceApi.getUserBalance(customerDetailVo.getCustomerId());
        log.info("balance\u7ed3\u679c\u4e3a : " + JsonUtils.toJson((Object)userBalance, (boolean)true));
        return BaseJsonVo.success((Object)customerInfoVo);
    }

    @RequestMapping(value={"/getCustomerInfoByCustomerId"})
    @ResponseBody
    public BaseJsonVo getCustomerInfoByCustomerId(String source) throws AuthorizeException {
        CustomerEntity customerEntity;
        if (StringUtils.isNotEmpty((String)source) && (customerEntity = this.customerInterface.getCustomer(source)) != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nickname", customerEntity.getNickName());
            map.put("img", customerEntity.getHeadImageUrl());
            return BaseJsonVo.success(map);
        }
        return BaseJsonVo.error((String)"\u53c2\u6570\u6709\u8bef");
    }

    @RequestMapping(value={"/getCustomerCentre"})
    @ResponseBody
    public BaseJsonVo getCustomerCentre(HttpServletRequest request, HttpServletResponse response) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        customerDetailVo.setMobile(StringUtils.rePlacePhone((String)customerDetailVo.getMobile()));
        CustomerCentreVo vo = new CustomerCentreVo();
        MallVipVo vipVo = this.vipService.getUserVipVO(customerDetailVo.getCustomerId());
        vo.setMallVipVo(vipVo);
        vo.setCustomerDetailVo(customerDetailVo);
        vo.setBalance(this.accountBalanceInterface.getGiftBalanceById(customerDetailVo.getCustomerId()));
        vo.setCashCount(this.cashticketCustomerInterface.getCashticketCount(customerDetailVo.getCustomerId(), Integer.valueOf(1)).intValue());
        vo.setOrderInfo(this.mallTradeInterface.getOrderCount(customerDetailVo.getCustomerId()));
        vo.setPlatFormGroupMobile(this.platFormGroupInterface.getPlatFormGroup(customerDetailVo.getPlatformGroupId().intValue()).getMobile());
        return BaseJsonVo.success((Object)vo);
    }

    @RequestMapping(value={"/getCustomerIds"})
    @ResponseBody
    public BaseJsonVo getCustomerIds(HttpServletRequest request, HttpServletResponse response) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)new CustomerIdslVo(customerDetailVo.getCustomerId(), customerDetailVo.getCustomerOpenId(), customerDetailVo.getPlatformGroupId(), customerDetailVo.getPlatformId()));
    }

    @RequestMapping(value={"/updateCustomerInfo"})
    @ResponseBody
    public BaseJsonVo updateCustomerInfo(HttpServletRequest request, HttpServletResponse response, CustomerInfoDetailEntity customerInfoDetailEntity) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.customerInfoDetailInterface.updateCustomerInfoDetail(customerDetailVo.getCustomerId(), customerInfoDetailEntity));
    }

    @RequestMapping(value={"/getSafeQuestion"})
    @ResponseBody
    public BaseJsonVo getSafeQuestion(HttpServletRequest request, HttpServletResponse response) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        List ls = this.dictionaryInterface.getValidDictionaryList(customerDetailVo.getPlatformGroupId(), Integer.valueOf(38));
        return BaseJsonVo.success((Object)ls);
    }

    private String decodeUserInfo(String encryptedData, String sessionKey, String iv) {
        String userInfo = "";
        try {
            byte[] resultByte = AESUtil2.decryptOfDiyIV((byte[])AESUtil.decodeBase64((String)encryptedData), (byte[])AESUtil.decodeBase64((String)sessionKey), (byte[])AESUtil.decodeBase64((String)iv));
            if (null != resultByte && resultByte.length > 0) {
                userInfo = new String(resultByte, "UTF-8");
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            log.error("", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return userInfo;
    }

    @RequestMapping(value={"/deleteUserCache"})
    @ResponseBody
    public BaseJsonVo deleteUserCache(HttpServletRequest request, HttpServletResponse response, String customerId) throws AuthorizeException {
        CustomerEntity ce = this.customerInterface.getCustomer(customerId);
        this.customerInterface.removeCache(ce);
        return BaseJsonVo.success((Object)"");
    }
}

