/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.deliver;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.controller.deliver.ExpressController;
import cc.lechun.mall.entity.deliver.OrderDeliverRecordVo;
import cc.lechun.mall.iservice.deliver.DeliverRouteInterface;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/express"})
public class ExpressController {
    private static final Logger log = LoggerFactory.getLogger(ExpressController.class);
    @Autowired
    private DeliverRouteInterface routeInterface;

    @RequestMapping(value={"/getRouteInfoForWexin"})
    public List<OrderDeliverRecordVo> getRouteInfoForWexin(String orderNo) {
        List recordVos = this.routeInterface.getRouteInfoForWexin(orderNo);
        return recordVos;
    }

    @RequestMapping(value={"/kuaidi100CallBack"})
    public void kuaidi100CallBack(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("\u5feb\u9012100\u56de\u8c03\u5f00\u59cb\u3002\u3002\u3002\u3002\u3002\u3002");
        NoticeResponse resp = new NoticeResponse(this);
        resp.setResult(false);
        resp.setReturnCode("500");
        resp.setMessage("\u4fdd\u5b58\u5931\u8d25");
        try {
            String param = request.getParameter("param");
            log.info(param);
            BaseJsonVo js = this.routeInterface.expressCallBack("kuaidi100", param);
            if (js.isSuccess()) {
                resp.setResult(true);
                resp.setReturnCode("200");
            }
            log.info("\u5feb\u9012100\u56de\u8c03\u7ed3\u675f\u3002\u3002\u3002\u3002\u3002\u3002");
            response.getWriter().print(JsonUtils.toJson((Object)resp, (boolean)false));
        }
        catch (Exception e) {
            resp.setMessage("\u4fdd\u5b58\u5931\u8d25" + e.getMessage());
            response.getWriter().print(JsonUtils.toJson((Object)resp, (boolean)false));
        }
    }
}

