/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.trade;

import cc.lechun.framework.common.utils.XmlUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.pay.AliPayNotifyEntity;
import cc.lechun.mall.entity.pay.WechatNotifyEntity;
import cc.lechun.mall.iservice.pay.PayOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayRecordInterface;
import cc.lechun.mall.iservice.trade.MallTradeInterface;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/trade"})
public class PayNotifyController {
    private static final Logger log = LoggerFactory.getLogger(PayNotifyController.class);
    @Autowired
    private PayOrderInterface payOrderInterface;
    @Autowired
    private MallTradeInterface tradeInterface;
    @Autowired
    private MallOrderPayRecordInterface orderPayRecordInterface;

    @RequestMapping(value={"/alipayWapNotify"})
    public void alipayWapNotify(HttpServletRequest request, HttpServletResponse res) {
        BaseJsonVo baseJsonVo;
        String isSuccess = "failure";
        String charSet = "";
        HashMap<String, String> params = new HashMap<String, String>();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            params.put(name, valueStr);
        }
        AliPayNotifyEntity aliPayNotifyEntity = (AliPayNotifyEntity)ObjectConvert.requestConvertToObject((HttpServletRequest)request, AliPayNotifyEntity.class);
        aliPayNotifyEntity.setRequestMap(params);
        BaseJsonVo result = this.payOrderInterface.aliPayWapNotify(aliPayNotifyEntity);
        if (result.isSuccess() && (baseJsonVo = this.tradeInterface.updateOrderPaySuccess(aliPayNotifyEntity.getOutTradeNo(), aliPayNotifyEntity.getAliPayTradeNo())).isSuccess()) {
            isSuccess = "success";
        }
        try {
            res.setContentType("text/html;charset=" + charSet);
            res.getWriter().write(isSuccess);
            res.getWriter().flush();
            res.getWriter().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/wechatPayNotify"})
    public void wechatPayNotify(HttpServletRequest request, HttpServletResponse res) {
        String isSuccess = "fail";
        String charSet = "UTF-8";
        String resultStr = "";
        log.info("\u5fae\u4fe1\u901a\u77e5\u8fdb\u5165");
        try {
            ServletInputStream inStream = request.getInputStream();
            ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outSteam.write(buffer, 0, len);
            }
            outSteam.close();
            inStream.close();
            resultStr = new String(outSteam.toByteArray(), "utf-8");
            log.info("++++wechatPayNotify param+++++++resultStr={}", (Object)resultStr);
        }
        catch (IOException e) {
            log.info("\u5fae\u4fe1\u901a\u77e5\u5f02\u5e38" + e.getMessage());
            e.printStackTrace();
        }
        SortedMap resultMap = XmlUtils.doXMLParseSort((String)resultStr);
        this.orderPayRecordInterface.updatePayRecordPayNotity((String)resultMap.get("out_trade_no"), (String)resultMap.get("attach"), resultStr);
        log.info("[" + (String)resultMap.get("attach") + "]\u652f\u4ed8\u6210\u529f\u56de\u8c03,\u5916\u90e8\u5e73\u53f0\u5355\u53f7[" + (String)resultMap.get("out_trade_no") + "],\u6d88\u606f\u4f53\uff1a" + resultStr);
        WechatNotifyEntity wechatNotifyEntity = (WechatNotifyEntity)ObjectConvert.mapConvertToObject((SortedMap)resultMap, WechatNotifyEntity.class);
        if (wechatNotifyEntity == null) {
            return;
        }
        wechatNotifyEntity.setMap(resultMap);
        log.info(JsonUtils.toJson((Object)wechatNotifyEntity, (boolean)true));
        BaseJsonVo result = this.payOrderInterface.wechatPayNotify(wechatNotifyEntity);
        log.info("\u5fae\u4fe1\u901a\u77e5\u7ed3\u679c\uff1a" + wechatNotifyEntity.getOrderMainNo() + "\uff1a" + result.isSuccess() + "," + result.getError_msg());
        if (result.isSuccess()) {
            BaseJsonVo baseJsonVo = this.tradeInterface.updateOrderPaySuccess(wechatNotifyEntity.getTradeNo(), wechatNotifyEntity.getThirdTradeNo());
            if (baseJsonVo.isSuccess()) {
                isSuccess = "SUCCESS";
            }
            log.info("\u5fae\u4fe1\u901a\u77e5,\u66f4\u6539\u8ba2\u5355\u72b6\u6001\uff1a" + wechatNotifyEntity.getOrderMainNo() + "\uff1a" + baseJsonVo.isSuccess() + "," + baseJsonVo.getMessage());
        }
        if (isSuccess.equals("SUCCESS")) {
            try {
                res.setContentType("text/html;charset=" + charSet);
                res.getWriter().write(this.returnXML(isSuccess, ""));
                res.getWriter().flush();
                res.getWriter().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/cmbPayNotify"})
    public void cmbPayNotify(HttpServletRequest request, HttpServletResponse res) {
        log.info("**cmbPayNotify\u62db\u5546\u94f6\u884c\u901a\u77e5\u8fdb\u5165***");
        String isSuccess = "N";
        String charSet = "UTF-8";
        String resultStr = "";
        try {
            ServletInputStream inStream = request.getInputStream();
            ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outSteam.write(buffer, 0, len);
            }
            outSteam.close();
            inStream.close();
            resultStr = new String(outSteam.toByteArray(), "utf-8");
            resultStr = URLDecoder.decode(resultStr, "UTF-8");
            log.info("++++cmbPayNotify param+++++++resultStr={}", (Object)resultStr);
            String[] resultStrList = resultStr.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : resultStrList) {
                int index = s.indexOf("=");
                String key = s.substring(0, index);
                String value = s.substring(index + 1);
                map.put(key, value);
            }
            if (map != null && "A001".equals(map.get("transStatus").toString())) {
                this.orderPayRecordInterface.updatePayRecordPayNotity(map.get("mhtOrderNo").toString(), null, resultStr);
                BaseJsonVo result = this.payOrderInterface.cmbPayNotify(map);
                log.info("cmbPayNotify  \u62db\u5546\u94f6\u884c\u901a\u77e5\u7ed3\u679c\uff1a" + map.get("mhtOrderNo").toString() + "\uff1a" + result.isSuccess() + "," + result.getError_msg());
                if (result.isSuccess()) {
                    BaseJsonVo baseJsonVo = this.tradeInterface.updateOrderPaySuccess(map.get("mhtOrderNo").toString(), map.get("nowPayOrderNo").toString());
                    if (baseJsonVo.isSuccess()) {
                        isSuccess = "Y";
                    }
                    log.info("cmbPayNotify \u901a\u77e5,\u66f4\u6539\u8ba2\u5355\u72b6\u6001\uff1a" + map.get("mhtOrderNo").toString() + "\uff1a" + baseJsonVo.isSuccess() + "," + baseJsonVo.getMessage());
                    if (isSuccess.equals("Y")) {
                        try {
                            isSuccess = "success=Y";
                            res.setContentType("text/html;charset=" + charSet);
                            res.getWriter().write(this.returnXML(isSuccess, ""));
                            res.getWriter().flush();
                            res.getWriter().close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            log.info("+++++++cmbPayNotify Exception \u62db\u5546\u94f6\u884c\u901a\u77e5\u5f02\u5e38" + e.getMessage());
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/wechatRefundNotify"})
    public void wechatRefundNotify(HttpServletRequest request, HttpServletResponse res) {
        String isSuccess = "fail";
        String charSet = "UTF-8";
        String resultStr = "";
        try {
            ServletInputStream inStream = request.getInputStream();
            ByteArrayOutputStream outSteam = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inStream.read(buffer)) != -1) {
                outSteam.write(buffer, 0, len);
            }
            outSteam.close();
            inStream.close();
            resultStr = new String(outSteam.toByteArray(), "utf-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SortedMap resultMap = XmlUtils.doXMLParseSort((String)resultStr);
        BaseJsonVo result = this.payOrderInterface.wechatRefundNotify(resultMap);
        if (result.isSuccess() && result.isSuccess()) {
            isSuccess = "SUCCESS";
        }
        try {
            res.setContentType("text/html;charset=" + charSet);
            res.getWriter().write(this.returnXML(isSuccess, ""));
            res.getWriter().flush();
            res.getWriter().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String returnXML(String return_code, String return_msg) {
        return "<xml><return_code><![CDATA[" + return_code + "]]></return_code><return_msg><![CDATA[" + return_msg + "]]></return_msg></xml>";
    }

    @RequestMapping(value={"/testres"})
    public void testres(HttpServletRequest request, HttpServletResponse res, String orderMainNo) {
        BaseJsonVo result = this.payOrderInterface.paySearch(orderMainNo);
        try {
            res.setContentType("text/html;charset=utf-8");
            res.getWriter().write(JsonUtils.toJson((Object)result, (boolean)false));
            res.getWriter().flush();
            res.getWriter().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

