/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.sales;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.sales.MallProductCategoryEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.iservice.sales.MallProductCategoryInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallRegularInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"product"})
public class MallProductController {
    private static final Logger log = LoggerFactory.getLogger(MallProductController.class);
    @Autowired
    private MallProductCategoryInterface categoryInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallRegularInterface mallRegularInterface;
    @Autowired
    private CustomerLoginService customerLoginService;

    @RequestMapping(value={"categorys"})
    public Map<String, Object> findAllCategory(String token) {
        if (!"1000".equals(token) || !"1002".equals(token)) {
            HashMap<String, Object> itemprops_get_response = new HashMap<String, Object>();
            itemprops_get_response.put("itemprops_get_response", "\u9519\u8bef\u7684token");
            return itemprops_get_response;
        }
        BaseJsonVo sr = this.categoryInterface.findAllCategory(token);
        if (sr.isSuccess()) {
            List list = (List)sr.getValue();
            HashMap<String, Object> itemprops_get_response = new HashMap<String, Object>();
            String last_modified = DateUtils.now((String)"");
            HashMap<String, Object> item_props = new HashMap<String, Object>();
            HashMap item_prop = new HashMap();
            ArrayList rtnlist = new ArrayList();
            for (MallProductCategoryEntity entity : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("pid", entity.getCategoryId());
                map.put("parent_pid", entity.getParentId() == null ? "" : entity.getParentId());
                map.put("name", entity.getCategoryName());
                map.put("sort_order", String.valueOf(entity.getSortOrder()));
                map.put("ileaf", entity.getParentId() == null ? "0" : "1");
                map.put("ilevel", entity.getParentId() == null ? "1" : "2");
                rtnlist.add(map);
            }
            item_prop.put("item_prop", rtnlist);
            item_props.put("item_props", item_prop);
            item_props.put("last_modified", last_modified);
            itemprops_get_response.put("itemprops_get_response", item_props);
            return itemprops_get_response;
        }
        HashMap<String, Object> itemprops_get_response = new HashMap<String, Object>();
        itemprops_get_response.put("itemprops_get_response", "\u67e5\u65e0\u6570\u636e");
        return itemprops_get_response;
    }

    @RequestMapping(value={"findAllProducts"})
    public Map<String, Object> findAllProducts(String token, Integer limitCount) {
        if (!"1".equals(token)) {
            HashMap<String, Object> products_search_response = new HashMap<String, Object>();
            products_search_response.put("products_search_response", "\u9519\u8bef\u7684token");
            return products_search_response;
        }
        BaseJsonVo sr = this.productInterface.findProductByToken(token, limitCount);
        if (sr.isSuccess()) {
            List list = (List)sr.getValue();
            HashMap<String, Object> products_search_response = new HashMap<String, Object>();
            HashMap<String, Serializable> products = new HashMap<String, Serializable>();
            HashMap product = new HashMap();
            ArrayList rtnlist = new ArrayList();
            for (MallProductEntity entity : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("cid", entity.getProductCategoryId());
                map.put("ccode", entity.getProId());
                map.put("cname", entity.getProName());
                map.put("cwareStatus", entity.getProState() == 1 ? "\u4e0a\u67b6" : "\u4e0b\u67b6");
                map.put("donlineTime", "");
                map.put("dofflineTime", entity.getDownDate() == null ? "" : entity.getDownDate());
                map.put("cdesc", entity.getMemo() == null ? "" : entity.getMemo());
                map.put("cwrap", "");
                map.put("ccostPrice", "");
                map.put("csalesPrice", "");
                map.put("cstockNum", "");
                map.put("cweight", "");
                rtnlist.add(map);
            }
            product.put("product", rtnlist);
            products.put("products", product);
            products.put("total_results", Integer.valueOf(rtnlist.size()));
            products_search_response.put("products_search_response", products);
            return products_search_response;
        }
        HashMap<String, Object> products_search_response = new HashMap<String, Object>();
        products_search_response.put("products_search_response", "\u67e5\u65e0\u7ed3\u679c");
        return products_search_response;
    }

    @RequestMapping(value={"getRegularProductList"})
    public BaseJsonVo getRegularProductList() {
        return this.mallRegularInterface.getRegularProductList(this.customerLoginService.getPlatFormAndGroup().getPlatformGroupId().intValue(), 1);
    }
}

