/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.subscribe;

import cc.lechun.common.enums.customer.SubscibeStatusEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.SubscribeMessageEntity;
import cc.lechun.mall.entity.customer.SubscribeResult;
import cc.lechun.mall.entity.customer.SubscribeTemplateVo;
import cc.lechun.mall.entity.weixin.TemplateMessageEntity;
import cc.lechun.mall.iservice.customer.SubscribeMessageInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/subscribe"})
public class SubscribeMessageController {
    private static final Logger log = LoggerFactory.getLogger(SubscribeMessageController.class);
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private TemplateMessageInterface templateMessageInterface;
    @Autowired
    private SubscribeMessageInterface subscribeMessageInterface;

    @RequestMapping(value={"/getCrowdTempMessageList"})
    public BaseJsonVo getTempMessageList() throws AuthorizeException {
        TemplateMessageEntity templateMessageEntity2;
        ArrayList<TemplateMessageEntity> list = new ArrayList<TemplateMessageEntity>();
        TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(Integer.valueOf(76));
        if (templateMessageEntity != null) {
            list.add(templateMessageEntity);
        }
        if ((templateMessageEntity2 = this.templateMessageInterface.getTemplateMessageById(Integer.valueOf(77))) != null) {
            list.add(templateMessageEntity2);
        }
        return BaseJsonVo.success(list);
    }

    @RequestMapping(value={"/getTempMessageList"})
    public BaseJsonVo getTempMessageList(String itemList) throws UnsupportedEncodingException {
        List parmList;
        List tempIds;
        ArrayList<TemplateMessageEntity> list = new ArrayList<TemplateMessageEntity>();
        String items = URLDecoder.decode(itemList, "UTF-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        if ((tempIds = (parmList = JsonUtils.getListByArray(SubscribeTemplateVo.class, (String)items)).stream().map(subscribeTemplateVo -> subscribeTemplateVo.getTemplateId()).collect(Collectors.toList())) != null && tempIds.size() > 0) {
            for (Integer tempId : tempIds) {
                TemplateMessageEntity templateMessageEntity = this.templateMessageInterface.getTemplateMessageById(tempId);
                if (templateMessageEntity == null) continue;
                list.add(templateMessageEntity);
            }
        } else {
            return BaseJsonVo.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        return BaseJsonVo.success(list);
    }

    @RequestMapping(value={"/saveTempMessageList"})
    public BaseJsonVo saveTempMessageList(String itemList) throws AuthorizeException, UnsupportedEncodingException {
        List parmList;
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        ArrayList<SubscribeMessageEntity> list = new ArrayList<SubscribeMessageEntity>();
        String items = URLDecoder.decode(itemList, "UTF-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        if ((parmList = JsonUtils.getListByArray(SubscribeResult.class, (String)items)) != null && parmList.size() > 0) {
            for (SubscribeResult itemTemp : parmList) {
                SubscribeMessageEntity subscribeMessageEntity = new SubscribeMessageEntity();
                subscribeMessageEntity.setCreateTime(DateUtils.now());
                subscribeMessageEntity.setPlatformId(customerDetailVo.getPlatformId());
                subscribeMessageEntity.setSubscribeType(Integer.valueOf(1));
                subscribeMessageEntity.setCustomerId(customerDetailVo.getCustomerId());
                subscribeMessageEntity.setStatus(Integer.valueOf(SubscibeStatusEnum.valueOf((String)itemTemp.getSubscribeStatus()).getValue()));
                subscribeMessageEntity.setTmplId(itemTemp.getTemplateId());
                list.add(subscribeMessageEntity);
            }
        }
        return BaseJsonVo.success((Object)this.subscribeMessageInterface.batchInsert(list));
    }

    @RequestMapping(value={"/testsaveTempMessageList"})
    public BaseJsonVo testsaveTempMessageList(String[] tmplIds, String subscribeStatus, Integer subscribeType) throws AuthorizeException {
        ArrayList<SubscribeMessageEntity> list = new ArrayList<SubscribeMessageEntity>();
        if (tmplIds != null && tmplIds.length > 0) {
            for (String tempId : tmplIds) {
                SubscribeMessageEntity subscribeMessageEntity = new SubscribeMessageEntity();
                subscribeMessageEntity.setCreateTime(DateUtils.now());
                subscribeMessageEntity.setPlatformId(Integer.valueOf(4));
                subscribeMessageEntity.setSubscribeType(Integer.valueOf(subscribeType == null ? 1 : subscribeType));
                subscribeMessageEntity.setCustomerId("10003269505280292656164");
                subscribeMessageEntity.setStatus(Integer.valueOf(SubscibeStatusEnum.valueOf((String)subscribeStatus).getValue()));
                subscribeMessageEntity.setTmplId(tempId);
                list.add(subscribeMessageEntity);
            }
        }
        return BaseJsonVo.success((Object)this.subscribeMessageInterface.batchInsert(list));
    }
}

