/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.api;

import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.iservice.cashticket.CashticketNoticeInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mallapi.api.MallCashApi;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallCashApiService
implements MallCashApi {
    private static final Logger logger = LoggerFactory.getLogger(MallCashApiService.class);
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private CashticketNoticeInterface cashticketNoticeInterface;

    public BaseJsonVo sendExpireMessage(Date date) {
        return this.cashticketNoticeInterface.sendExpireMessage(date);
    }

    public BaseJsonVo sendCashticketByTicketBatchId(String customerId, String ticketBatchId, Integer platFormId) {
        return this.activeCashticketInterface.sendCashticketByTicketBatchId(customerId, ticketBatchId, platFormId);
    }

    public BaseJsonVo sendCashticket(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog) {
        if (StringUtils.isNotEmpty((String)customerId) && customerId.length() == 11) {
            CustomerEntity customerEntity = this.customerInterface.getCustomerByMobile(customerId, this.platFormInterface.getPlatFormGroupId(platFormId.intValue()));
            if (customerEntity != null) {
                customerId = customerEntity.getCustomerId();
            } else {
                logger.info("\u624b\u673a\u53f7{}\u7ed1\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a,\u4f18\u60e0\u5238\u4e0d\u53d1\u653e", (Object)customerId);
                return BaseJsonVo.success((Object)("\u624b\u673a\u53f7" + customerId + "\u7ed1\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a,\u4f18\u60e0\u5238\u4e0d\u53d1\u653e"));
            }
        }
        return this.activeCashticketInterface.sendTicket4Base(customerId, bindCode, amount, versionDetailId, platFormId, isSendMessage, writeLog);
    }

    public BaseJsonVo sendCashticket(String customerId, String bindCode, double amount, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog, boolean checkActive) {
        return this.activeCashticketInterface.sendTicket4Base(customerId, bindCode, amount, versionDetailId, platFormId, isSendMessage, writeLog, checkActive);
    }

    public BaseJsonVo sendCashticketMq(String customerId, String bindCode, String versionDetailId, Integer platFormId, boolean isSendMessage, boolean writeLog) {
        if (StringUtils.isNotEmpty((String)customerId) && customerId.length() == 11) {
            CustomerEntity customerEntity = this.customerInterface.getCustomerByMobile(customerId, this.platFormInterface.getPlatFormGroupId(platFormId.intValue()));
            if (customerEntity != null) {
                customerId = customerEntity.getCustomerId();
            } else {
                logger.info("\u624b\u673a\u53f7{}\u7ed1\u5b9a\u7684\u7528\u6237\u4e3a\u7a7a,\u4f18\u60e0\u5238\u4e0d\u53d1\u653e", (Object)customerId);
            }
        }
        this.activeCashticketInterface.sendTicket4BaseAsynchronous(customerId, bindCode, versionDetailId, platFormId, isSendMessage, writeLog);
        return BaseJsonVo.success((Object)"\u6d88\u606f\u63a8\u9001\u6210\u529f");
    }
}

