/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.customerqrcode;

import cc.lechun.active.iservice.active.CustomerQrcodeInterface;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/code"})
public class CustomerQrcodeController {
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private CustomerQrcodeInterface customerQrcodeInterface;

    @RequestMapping(value={"/getQrcode"})
    public BaseJsonVo getQrcode(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.customerQrcodeInterface.getSaleQrcodeVo(customerDetailVo.getCustomerId(), customerDetailVo.getPlatformId(), bindCode);
    }

    @RequestMapping(value={"/getFunds"})
    public BaseJsonVo getFunds(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.customerQrcodeInterface.getFunds(customerDetailVo.getCustomerId(), bindCode);
    }

    @RequestMapping(value={"/prize"})
    public BaseJsonVo prize(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.customerQrcodeInterface.prize(customerDetailVo.getCustomerId(), customerDetailVo.getPlatformId(), bindCode);
    }

    @RequestMapping(value={"/testQrcode"})
    public BaseJsonVo testQrcode(String bindCode) throws AuthorizeException {
        return this.customerQrcodeInterface.getSaleQrcodeVo("10003355426914989387638", Integer.valueOf(1), bindCode);
    }
}

