/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.fitfive;

import cc.lechun.active.controller.common.ActiveCommonController;
import cc.lechun.active.iservice.fit.FitInterface;
import cc.lechun.active.vo.FitActiveInviteResultVo;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.customer.CustomerAdCookieInterface;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fit"})
public class NormalFitController {
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private FitInterface fitInterface;
    @Autowired
    private CustomerAdCookieInterface customerAdCookieInterface;
    @Autowired
    private ActiveCommonController activeCommonController;

    @RequestMapping(value={"/getActivePicList"})
    public BaseJsonVo getActivePicList(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.fitInterface.prizeActive(bindCode, customerDetailVo.getCustomerId(), customerDetailVo.getPlatformId());
    }

    @RequestMapping(value={"/isJoinActive"})
    public BaseJsonVo canJoinActive(String bindCode, String source) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.fitInterface.canJoinActive(customerDetailVo.getCustomerId(), bindCode, source);
    }

    @RequestMapping(value={"/testcanJoinActive"})
    public BaseJsonVo testcanJoinActive(String bindCode, String source) throws AuthorizeException {
        return this.fitInterface.canJoinActive("3068386641843735195", bindCode, source);
    }

    @RequestMapping(value={"/getActiveInvite"})
    public BaseJsonVo getActiveInvite(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.fitInterface.getActiveInvite(bindCode, customerDetailVo.getCustomerId(), customerDetailVo.getOpenId(), customerDetailVo.getPlatformId());
        if (baseJsonVo.isSuccess()) {
            FitActiveInviteResultVo fitActiveInviteResultVo = (FitActiveInviteResultVo)baseJsonVo.getValue();
            fitActiveInviteResultVo.setNickName(StringUtils.isNotEmpty((String)customerDetailVo.getNickName()) ? customerDetailVo.getNickName() : "");
            fitActiveInviteResultVo.setHeadImg(StringUtils.isNotEmpty((String)customerDetailVo.getHeadImageUrl()) ? customerDetailVo.getHeadImageUrl() : "");
            List list = this.fitInterface.getActiveRuleList(bindCode);
            fitActiveInviteResultVo.setCouponList(list == null ? new ArrayList() : list);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/prizeActive"})
    public BaseJsonVo prizeActive(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.fitInterface.prizeActive(bindCode, customerDetailVo.getCustomerId(), customerDetailVo.getPlatformId());
    }

    @RequestMapping(value={"/testprizeActive"})
    public BaseJsonVo testprizeActive(String bindCode) throws AuthorizeException {
        return this.fitInterface.prizeActive(bindCode, "10003334409279217327687", Integer.valueOf(4));
    }

    @RequestMapping(value={"/getShare"})
    public BaseJsonVo getShare(HttpServletRequest request, HttpServletResponse response, String bindCode, String productId, Integer groupType, String adCookie, String gdt_vid, String dataSource, Integer itemType, String itemId, String referer, String orderNo) throws AuthorizeException {
        return this.activeCommonController.getShareByBindCode(request, response, bindCode, productId, groupType, adCookie, gdt_vid, dataSource, itemType, itemId, referer, orderNo);
    }
}

