/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.reunion;

import cc.lechun.active.iservice.invite.ActiveInviteInterface;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.qrcode.MiniQrcodeEntity;
import cc.lechun.mall.entity.reunion.ReunionCustomerLoveEntity;
import cc.lechun.mall.entity.reunion.ReunionCustomerLoveVo;
import cc.lechun.mall.entity.reunion.ReunionIndexVo;
import cc.lechun.mall.entity.reunion.ReunionInfoVo;
import cc.lechun.mall.entity.reunion.ReunionOrderEntity;
import cc.lechun.mall.entity.reunion.ReunionOrderVO;
import cc.lechun.mall.entity.reunion.ReunionProductVO;
import cc.lechun.mall.entity.reunion.ReunionSiteEntity;
import cc.lechun.mall.entity.reunion.SwapReunionProductTypeVO;
import cc.lechun.mall.iservice.qrcode.MiniQrcodeInterface;
import cc.lechun.mall.iservice.reunion.ReunionCustomerLoveInterface;
import cc.lechun.mall.iservice.reunion.ReunionInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderProductRecoveryInterface;
import cc.lechun.mall.iservice.reunion.ReunionOrderProductSwapInterface;
import cc.lechun.mall.iservice.reunion.ReunionProductInterface;
import cc.lechun.mall.iservice.reunion.ReunionSiteInterface;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reunion"})
public class ReunionController {
    private static final Logger log = LoggerFactory.getLogger(ReunionController.class);
    @Autowired
    CustomerLoginService customerLoginService;
    @Autowired
    ReunionOrderInterface reunionOrderInterface;
    @Autowired
    ReunionProductInterface reunionProductInterface;
    @Autowired
    ReunionCustomerLoveInterface reunionCustomerLoveInterface;
    @Autowired
    private ReunionInterface reunionInterface;
    @Autowired
    private ReunionOrderProductRecoveryInterface reunionOrderProductRecoveryInterface;
    @Autowired
    private ReunionOrderProductSwapInterface reunionOrderProductSwapInterface;
    @Autowired
    MiniQrcodeInterface miniQrcodeInterface;
    @Autowired
    ActiveInviteInterface activeInviteInterface;
    @Autowired
    private ReunionSiteInterface reunionSiteInterface;

    @RequestMapping(value={"/getRankList"})
    public BaseJsonVo getRankList(String bindCode, int pageSize, int currentPage) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.activeInviteInterface.getRankList(bindCode, pageSize, currentPage));
    }

    @RequestMapping(value={"/getMiniQrcodeBySence"})
    public BaseJsonVo getMiniQrcodeBySence(Integer scene) throws AuthorizeException {
        ReunionOrderEntity reunionOrderEntity;
        if (scene == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u53c2\u6570");
        }
        int platformId = this.customerLoginService.getPlatFormId();
        HashMap<String, String> map = new HashMap<String, String>();
        MiniQrcodeEntity miniQrcodeEntity = (MiniQrcodeEntity)this.miniQrcodeInterface.selectByPrimaryKey((Serializable)scene);
        map.put("inviteId", miniQrcodeEntity.getCustomerId());
        ReunionIndexVo reunionIndexVo = (ReunionIndexVo)this.getReunionInfo(miniQrcodeEntity.getBindCode()).getValue();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        String customerId = "";
        if (customerDetailVo != null) {
            customerId = customerDetailVo.getCustomerId();
            reunionIndexVo.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
            reunionIndexVo.setNickName(customerDetailVo.getNickName());
        }
        if ((reunionOrderEntity = this.reunionOrderInterface.getReunionOrder(miniQrcodeEntity.getBindCode(), customerId)) != null) {
            reunionIndexVo.setOrderStatus(reunionOrderEntity.getOrderStatus());
            BaseJsonVo baseJsonVo = this.reunionOrderInterface.orderDetail(customerId, miniQrcodeEntity.getBindCode(), platformId);
            if (baseJsonVo.isSuccess()) {
                reunionIndexVo.setHasAmount(((ReunionOrderVO)baseJsonVo.getValue()).getHasAmount());
            }
        } else {
            reunionIndexVo.setOrderStatus(Integer.valueOf(0));
        }
        map.put("reunionInfo", (String)reunionIndexVo);
        map.put("bindCode", miniQrcodeEntity.getBindCode());
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/getReunionInfo"})
    public BaseJsonVo getReunionInfo(String bindCode) throws AuthorizeException {
        ReunionOrderEntity reunionOrderEntity;
        int platformId = this.customerLoginService.getPlatFormId();
        ReunionIndexVo reunionIndexVo = this.reunionInterface.getReunionIndexVo(bindCode, Integer.valueOf(platformId));
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        String customerId = "";
        if (customerDetailVo != null) {
            customerId = customerDetailVo.getCustomerId();
            reunionIndexVo.setHeadImageUrl(customerDetailVo.getHeadImageUrl());
            reunionIndexVo.setNickName(customerDetailVo.getNickName());
        }
        if ((reunionOrderEntity = this.reunionOrderInterface.getReunionOrder(bindCode, customerId)) != null) {
            reunionIndexVo.setOrderStatus(reunionOrderEntity.getOrderStatus());
            BaseJsonVo baseJsonVo = this.reunionOrderInterface.orderDetail(customerId, bindCode, platformId);
            if (baseJsonVo.isSuccess()) {
                reunionIndexVo.setHasAmount(((ReunionOrderVO)baseJsonVo.getValue()).getHasAmount());
            }
        } else {
            reunionIndexVo.setOrderStatus(Integer.valueOf(0));
        }
        return BaseJsonVo.success((Object)reunionIndexVo);
    }

    @RequestMapping(value={"saveOrderSite"})
    public BaseJsonVo saveOrderSite(String bindCode, Integer siteId, String inviteId, String province, String city, String area, String address) throws AuthorizeException {
        log.info("\u4fdd\u5b58\u7ad9\u70b9\u53c2\u6570:bindCode={},siteId={},inviteId={},province={},city={},address={}", new Object[]{bindCode, siteId, inviteId, province, city, area});
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reunionOrderInterface.saveReunionOrder(customer, bindCode, siteId, inviteId, Integer.valueOf(this.reunionSiteInterface.getAddressType(address, province, city, area, siteId.intValue())));
    }

    @RequestMapping(value={"recoveryList"})
    public BaseJsonVo recoveryList(String bindCode) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        if (StringUtils.isEmpty((String)bindCode)) {
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u671f\u6d3b\u52a8\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u6d3b\u52a8\u9996\u9875");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReunionInfoVo reunionInfoVo = this.reunionInterface.getReunionInfoVo(bindCode);
        BaseJsonVo rst = this.reunionProductInterface.recoveryList(bindCode, customer.getCustomerId());
        ReunionOrderEntity reunionOrderEntity = this.reunionOrderInterface.getReunionOrder(bindCode, customer.getCustomerId());
        if (reunionOrderEntity != null) {
            ReunionSiteEntity reunionSiteEntity = (ReunionSiteEntity)this.reunionSiteInterface.selectByPrimaryKey((Serializable)reunionOrderEntity.getReunionSiteId());
            map.put("siteAddress", reunionSiteEntity);
        } else {
            map.put("siteAddress", null);
        }
        map.put("recoveryList", rst.getValue());
        map.put("recoveryTitle", reunionInfoVo.getRecoveryTitle());
        map.put("recoveryDesc", reunionInfoVo.getRecoveryDesc());
        map.put("recoveryAmount", reunionOrderEntity == null || reunionOrderEntity.getLoveRecoveryAmount() == null ? BigDecimal.ZERO : reunionOrderEntity.getLoveRecoveryAmount());
        ReunionCustomerLoveEntity customerLoveEntity = (ReunionCustomerLoveEntity)this.reunionCustomerLoveInterface.customerLove(customer.getCustomerId()).getValue();
        map.put("customerShareAmount", customerLoveEntity != null ? customerLoveEntity.getLoveShare() : BigDecimal.ZERO);
        map.put("customerRemainAmout", customerLoveEntity != null ? customerLoveEntity.getLoveRemain() : BigDecimal.ZERO);
        map.put("totalAmount", ((BigDecimal)map.get("recoveryAmount")).add((BigDecimal)map.get("customerShareAmount")).add((BigDecimal)map.get("customerRemainAmout")));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"swapList"})
    public BaseJsonVo swapList(String bindCode) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        if (StringUtils.isEmpty((String)bindCode)) {
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u671f\u6d3b\u52a8\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u6d3b\u52a8\u9996\u9875");
        }
        ReunionOrderEntity reunionOrderEntity = this.reunionOrderInterface.getReunionOrder(bindCode, customer.getCustomerId());
        if (reunionOrderEntity == null) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u5236\u8ba2\u8ba1\u5212\uff0c\u8bf7\u5148\u5b9a\u5236\u8ba1\u5212\u540e\u518d\u8bd5");
        }
        ReunionSiteEntity reunionSiteEntity = (ReunionSiteEntity)this.reunionSiteInterface.selectByPrimaryKey((Serializable)reunionOrderEntity.getReunionSiteId(), 0L);
        List list = this.reunionProductInterface.getSwapList(bindCode, customer.getCustomerId(), reunionOrderEntity);
        ReunionInfoVo reunionInfoVo = this.reunionInterface.getReunionInfoVo(bindCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("siteAddress", reunionSiteEntity);
        map.put("swapList", list);
        map.put("swapTitle", reunionInfoVo.getExchangeTitle());
        map.put("swapDesc", reunionInfoVo.getExchangeDesc());
        map.put("recoveryAmount", reunionOrderEntity.getLoveRecoveryAmount() == null ? BigDecimal.ZERO : reunionOrderEntity.getLoveRecoveryAmount());
        map.put("swapAmount", reunionOrderEntity.getLoveSwapAmount() == null ? BigDecimal.ZERO : reunionOrderEntity.getLoveSwapAmount());
        ReunionCustomerLoveEntity customerLoveEntity = (ReunionCustomerLoveEntity)this.reunionCustomerLoveInterface.customerLove(customer.getCustomerId()).getValue();
        map.put("customerShareAmount", customerLoveEntity.getLoveShare());
        map.put("customerRemainAmout", customerLoveEntity.getLoveRemain());
        map.put("totalAmount", ((BigDecimal)map.get("recoveryAmount")).add((BigDecimal)map.get("customerShareAmount")).add((BigDecimal)map.get("customerRemainAmout")).subtract((BigDecimal)map.get("swapAmount")));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"saveOrderRecoveryProducts"})
    public BaseJsonVo saveOrderRecoveryProducts(String bindCode, String items, Integer siteId, String inviteId) throws AuthorizeException, UnsupportedEncodingException {
        log.info("\u4fdd\u5b58\u56de\u6536\u5546\u54c1 bindCode : {},items={},siteId={},inviteId={}", new Object[]{bindCode, items, siteId, inviteId});
        items = URLDecoder.decode(items, "utf-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        List recovery = JsonUtils.getListByArray(ReunionProductVO.class, (String)items);
        if (recovery == null || recovery.size() == 0) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u56de\u6536\u54c1!");
        }
        BaseJsonVo baseJsonVo = this.reunionOrderInterface.saveReunionOrder(customer, bindCode, siteId, inviteId, null);
        if (baseJsonVo.isSuccess()) {
            return this.reunionOrderProductRecoveryInterface.saveRecoveryList(customer.getCustomerId(), bindCode, recovery);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"saveOrderSwapProducts"})
    public BaseJsonVo saveOrderSwapProducts(String bindCode, String items) throws AuthorizeException, UnsupportedEncodingException {
        log.info("bindCode : {},items={}", (Object)bindCode, (Object)items);
        items = URLDecoder.decode(items, "utf-8");
        if (!items.startsWith("[")) {
            items = "[" + items + "]";
        }
        List swap = JsonUtils.getListByArray(SwapReunionProductTypeVO.class, (String)items);
        log.info("swap : {}", (Object)JsonUtils.toJson((Object)swap, (boolean)false));
        if (swap == null || swap.size() == 0) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u7279\u4ea7!");
        }
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reunionOrderProductSwapInterface.saveSelectSwapList(customer.getCustomerId(), bindCode, swap);
    }

    @RequestMapping(value={"orderDetail"})
    public BaseJsonVo orderDetail(String bindCode) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reunionOrderInterface.orderDetail(customer.getCustomerId(), bindCode, platformId);
    }

    @RequestMapping(value={"ensureOrder"})
    public BaseJsonVo ensureOrder(String inviteId, Integer orderId, String exchangeTime, String mobile) throws AuthorizeException {
        log.info(" \u786e\u8ba4\u8ba1\u5212\u53c2\u6570 orderId={},inviteId={},\u5c65\u7ea6\u65e5\u671f:{}", new Object[]{orderId, inviteId, exchangeTime});
        if (StringUtils.isEmpty((String)exchangeTime)) {
            return BaseJsonVo.error((String)"\u8bf7\u9009\u62e9\u5c65\u7ea6\u65e5\u671f!");
        }
        if (StringUtils.isEmpty((String)mobile)) {
            return BaseJsonVo.error((String)"\u8bf7\u586b\u5199\u624b\u673a\u53f7!");
        }
        if (!mobile.trim().startsWith("1") || mobile.trim().length() != 11) {
            return BaseJsonVo.error((String)"\u624b\u673a\u53f7\u586b\u5199\u6709\u8bef!");
        }
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reunionOrderInterface.ensureOrder(customer, orderId, inviteId, DateUtils.getDateFromString((String)(exchangeTime + " 00:00:00"), (String)""), mobile);
    }

    @RequestMapping(value={"orderList"})
    public BaseJsonVo orderList(Integer type) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reunionOrderInterface.orderList(type, customer.getCustomerId(), customer.getNickName());
    }

    @RequestMapping(value={"testOrderList"})
    public BaseJsonVo testOrderList(Integer type) throws AuthorizeException {
        BaseJsonVo rst = this.reunionOrderInterface.orderList(type, "10003355426914989387638", "\u6d6a\u82b1");
        return rst;
    }

    @RequestMapping(value={"myOrder"})
    public BaseJsonVo myOrder(String bindCode) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        BaseJsonVo rst = this.reunionOrderInterface.myOrder(customer.getPlatformId(), customer.getCustomerId(), customer.getNickName(), bindCode);
        return rst;
    }

    @RequestMapping(value={"closeOpenOrder"})
    public BaseJsonVo closeOpenOrder(Integer orderId) throws AuthorizeException {
        BaseJsonVo rst = this.reunionOrderInterface.closeOpenOrder(orderId);
        return rst;
    }

    @RequestMapping(value={"progressBarInfo"})
    public BaseJsonVo progressBarInfo(String bindCode) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.reunionInterface.getReunionInfoVo(bindCode).getExchangeRewardInfoVo());
    }

    @RequestMapping(value={"shareData"})
    public BaseJsonVo shareData(String bindCode) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.reunionCustomerLoveInterface.shareData(customer.getCustomerId(), bindCode);
    }

    @RequestMapping(value={"customerLove"})
    public BaseJsonVo customerLove(String bindCode) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        BaseJsonVo rst = this.reunionCustomerLoveInterface.customerLove(customer.getCustomerId());
        if (rst.isSuccess()) {
            ReunionCustomerLoveEntity reunionCustomerLoveEntity = (ReunionCustomerLoveEntity)rst.getValue();
            ReunionCustomerLoveVo reunionCustomerLoveVo = new ReunionCustomerLoveVo();
            BeanUtils.copyProperties((Object)reunionCustomerLoveEntity, (Object)reunionCustomerLoveVo);
            ReunionOrderEntity reunionOrderEntity = this.reunionOrderInterface.getReunionOrder(bindCode, customer.getCustomerId());
            if (reunionOrderEntity != null) {
                reunionCustomerLoveVo.setRecoverAmount(reunionOrderEntity.getLoveRecoveryAmount());
            }
            return BaseJsonVo.success((Object)reunionCustomerLoveVo);
        }
        return rst;
    }

    @RequestMapping(value={"testCustomerLove"})
    public BaseJsonVo testCustomerLove() throws AuthorizeException {
        BaseJsonVo rst = this.reunionCustomerLoveInterface.customerLove("10003355426914989387638");
        return rst;
    }

    @RequestMapping(value={"/TestGetReunionInfo"})
    public BaseJsonVo TestGetReunionInfo(String bindCode) throws AuthorizeException {
        int platformId = 4;
        ReunionIndexVo reunionIndexVo = this.reunionInterface.getReunionIndexVo(bindCode, Integer.valueOf(platformId));
        reunionIndexVo.setHeadImageUrl("customerDetailVo.getHeadImageUrl()");
        reunionIndexVo.setNickName("customerDetailVo.getNickName()");
        return BaseJsonVo.success((Object)reunionIndexVo);
    }

    @RequestMapping(value={"getShareData"})
    public BaseJsonVo getShareData(String bindCode) throws AuthorizeException {
        BaseJsonVo rst = this.reunionCustomerLoveInterface.shareData("10003355426914989387638", bindCode);
        return rst;
    }

    @RequestMapping(value={"/testGetMiniQrcode"})
    public BaseJsonVo testGetMiniQrcode(String bindCode) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.miniQrcodeInterface.getQrcodePath(Integer.valueOf(4), "10003355426914989387638", bindCode, Integer.valueOf(300)));
    }

    @RequestMapping(value={"/getReunionStatusInfoVo"})
    public BaseJsonVo getReunionStatusInfoVo(String bindCode) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.reunionInterface.getReunionStatusInfoVo(bindCode));
    }

    @RequestMapping(value={"/saveActiveInvite"})
    public BaseJsonVo saveActiveInvite(String inviteId, String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = new CustomerDetailVo();
        customerDetailVo.setCustomerId("10003355426914989387638");
        customerDetailVo.setPlatformId(Integer.valueOf(4));
        customerDetailVo.setPlatformGroupId(Integer.valueOf(1000));
        this.activeInviteInterface.saveActiveInvite(inviteId, bindCode, customerDetailVo);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/setActiveInviteSuccess"})
    public BaseJsonVo setActiveInviteSuccess(String inviteId, String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = new CustomerDetailVo();
        customerDetailVo.setCustomerId("10003355426914989387638");
        customerDetailVo.setPlatformId(Integer.valueOf(4));
        customerDetailVo.setPlatformGroupId(Integer.valueOf(1000));
        this.activeInviteInterface.setActiveInviteSuccess(inviteId, bindCode, customerDetailVo);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"testSwapList"})
    public BaseJsonVo testSwapList(String bindCode) throws AuthorizeException {
        if (StringUtils.isEmpty((String)bindCode)) {
            return BaseJsonVo.error((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u671f\u6d3b\u52a8\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u6d3b\u52a8\u9996\u9875");
        }
        ReunionOrderEntity reunionOrderEntity = this.reunionOrderInterface.getReunionOrder(bindCode, "10003355426914989387638");
        if (reunionOrderEntity == null) {
            return BaseJsonVo.error((String)"\u6ca1\u6709\u5236\u8ba2\u8ba1\u5212\uff0c\u8bf7\u5148\u5b9a\u5236\u8ba1\u5212\u540e\u518d\u8bd5");
        }
        return BaseJsonVo.success((Object)this.reunionProductInterface.getSwapList(bindCode, "10003355426914989387638", reunionOrderEntity));
    }

    @RequestMapping(value={"/testSaveOrderSite"})
    public BaseJsonVo testSaveOrderSite(String bindCode, Integer siteId, String inviteId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = new CustomerDetailVo();
        customerDetailVo.setCustomerId("10003355426914989387638");
        customerDetailVo.setPlatformId(Integer.valueOf(4));
        customerDetailVo.setPlatformGroupId(Integer.valueOf(1000));
        return this.reunionOrderInterface.saveReunionOrder(customerDetailVo, bindCode, siteId, inviteId, Integer.valueOf(0));
    }

    @RequestMapping(value={"/testSaveOrderSite2"})
    public BaseJsonVo testSaveOrderSite2(String bindCode, Integer siteId, String inviteId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = new CustomerDetailVo();
        customerDetailVo.setCustomerId("10003238205637826179374");
        customerDetailVo.setPlatformId(Integer.valueOf(4));
        customerDetailVo.setPlatformGroupId(Integer.valueOf(1000));
        return this.reunionOrderInterface.saveReunionOrder(customerDetailVo, bindCode, siteId, inviteId, Integer.valueOf(0));
    }

    @RequestMapping(value={"/testRecordInvite"})
    public BaseJsonVo testRecordInvite(String bindCode, String inviteId, String customerId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = new CustomerDetailVo();
        customerDetailVo.setCustomerId(customerId);
        customerDetailVo.setPlatformId(Integer.valueOf(4));
        customerDetailVo.setPlatformGroupId(Integer.valueOf(1000));
        return this.reunionOrderInterface.saveActiveInvite(inviteId, bindCode, customerDetailVo);
    }

    @RequestMapping(value={"/testSaveOrderSite3"})
    public BaseJsonVo testSaveOrderSite3(String bindCode, Integer siteId, String inviteId, String customerId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = new CustomerDetailVo();
        customerDetailVo.setCustomerId(customerId);
        customerDetailVo.setPlatformId(Integer.valueOf(4));
        customerDetailVo.setPlatformGroupId(Integer.valueOf(1000));
        return this.reunionOrderInterface.saveReunionOrder(customerDetailVo, bindCode, siteId, inviteId, Integer.valueOf(1));
    }

    @RequestMapping(value={"/getInviteList"})
    public BaseJsonVo getInviteList(String inviteId, String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = new CustomerDetailVo();
        customerDetailVo.setCustomerId("10003355426914989387638");
        customerDetailVo.setPlatformId(Integer.valueOf(4));
        customerDetailVo.setPlatformGroupId(Integer.valueOf(1000));
        return BaseJsonVo.success((Object)this.activeInviteInterface.getRankList(bindCode, 1, 10));
    }

    @RequestMapping(value={"testEnsureOrder"})
    public BaseJsonVo testEnsureOrder(String inviteId, Integer orderId, String customerId, String exchangeTime, String mobile) throws AuthorizeException {
        log.info(" \u786e\u8ba4\u8ba1\u5212\u53c2\u6570 orderId={},inviteId={}", (Object)orderId, (Object)inviteId);
        CustomerDetailVo customerDetailVo = new CustomerDetailVo();
        customerDetailVo.setCustomerId(customerId);
        customerDetailVo.setPlatformId(Integer.valueOf(4));
        customerDetailVo.setPlatformGroupId(Integer.valueOf(1000));
        BaseJsonVo rst = this.reunionOrderInterface.ensureOrder(customerDetailVo, orderId, inviteId);
        return rst;
    }

    @RequestMapping(value={"/getTestOrderDetail"})
    public BaseJsonVo getTestOrderDetail(String inviteId, String bindCode) throws AuthorizeException {
        return this.reunionOrderInterface.orderDetail("10003355426914989387638", bindCode, 4);
    }

    @RequestMapping(value={"/getTestSwapProduct"})
    public BaseJsonVo getTestSwapProduct(String bindCode) throws AuthorizeException {
        BaseJsonVo rst = this.reunionProductInterface.recoveryList(bindCode, "10003355426914989387638");
        return rst;
    }
}

