/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.api;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.dao.customer.CustomerAddressMapper;
import cc.lechun.mall.entity.customer.AreaCityProvinceVo;
import cc.lechun.mall.entity.customer.CustomerAddressEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.trade.MallOrderGroupProductEntity;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.iservice.deliver.MallAreaInterface;
import cc.lechun.mall.iservice.deliver.MallCityInterface;
import cc.lechun.mall.iservice.deliver.MallProvinceInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mallapi.api.OrderEditApi;
import cc.lechun.mallapi.dto.EditOrderAddressDTO;
import cc.lechun.mallapi.dto.RefundProductDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class OrderEditApiService
implements OrderEditApi {
    @Autowired
    MallOrderInterface orderInterface;
    @Autowired
    MallAreaInterface mallAreaInterface;
    @Autowired
    MallCityInterface mallCityInterface;
    @Autowired
    MallProvinceInterface mallProvinceInterface;
    @Autowired
    CustomerAddressMapper customerAddressMapper;
    @Autowired
    MallOrderGroupProductInterface mallOrderGroupProductInterface;
    @Autowired
    MallOrderProductInterface mallOrderProductInterface;
    @Autowired
    MallProductInterface mallProductInterface;

    public BaseJsonVo<String> editOrderAddress(@RequestBody EditOrderAddressDTO editOrderAddressDTO) {
        CustomerAddressEntity address = new CustomerAddressEntity();
        address.setCustomerId(editOrderAddressDTO.getCustomerId());
        if (editOrderAddressDTO.getAreaId() == null) {
            return BaseJsonVo.error((String)"areaId\u4e3a\u5fc5\u4f20\u5b57\u6bb5");
        }
        address.setAreaId(editOrderAddressDTO.getAreaId());
        address.setAreaName(editOrderAddressDTO.getAreaName());
        address.setCityName(editOrderAddressDTO.getCityName());
        address.setProvinceName(editOrderAddressDTO.getProvinceName());
        AreaCityProvinceVo areaCityProvince = this.customerAddressMapper.getAreaCityProvinceForAreaId(editOrderAddressDTO.getAreaId().intValue());
        if (StringUtils.isEmpty((String)editOrderAddressDTO.getAreaName())) {
            address.setAreaName(areaCityProvince.getAreaName());
        }
        if (editOrderAddressDTO.getCityId() == null) {
            address.setCityId(Integer.valueOf(areaCityProvince.getCityId()));
        }
        if (StringUtils.isEmpty((String)editOrderAddressDTO.getCityName())) {
            address.setCityName(areaCityProvince.getCityName());
        }
        if (editOrderAddressDTO.getProvinceId() == null) {
            address.setProvinceId(Integer.valueOf(areaCityProvince.getProvinceId()));
        }
        if (StringUtils.isEmpty((String)editOrderAddressDTO.getProvinceName())) {
            address.setProvinceName(areaCityProvince.getProvinceName());
        }
        address.setAddress(editOrderAddressDTO.getAddress());
        address.setConsigneeName(editOrderAddressDTO.getConsigneeName());
        address.setConsigneePhone(editOrderAddressDTO.getConsigneePhone());
        return this.orderInterface.editOrderAddress(editOrderAddressDTO.getCustomerId(), editOrderAddressDTO.getOrderNo(), address, Boolean.valueOf(true));
    }

    public BaseJsonVo<String> editOrderDeliverDate(@RequestBody EditOrderAddressDTO editOrderAddressDTO) {
        return this.orderInterface.editOrderDeliverDate(editOrderAddressDTO.getCustomerId(), editOrderAddressDTO.getOrderNo(), editOrderAddressDTO.getDeliverDate(), Boolean.valueOf(true));
    }

    public BaseJsonVo<String> editOrderProducts(@RequestBody EditOrderAddressDTO editOrderAddressDTO) {
        ArrayList productList = new ArrayList();
        for (String pro : editOrderAddressDTO.getNewProductsStr().split(";")) {
            String[] proArray = pro.split(":");
            HashMap<String, String> map = new HashMap<String, String>();
            MallProductEntity product = this.mallProductInterface.getProductByBarcode(proArray[0]);
            map.put("proId", product == null ? "" : product.getProId());
            map.put("count", proArray[1]);
            productList.add(map);
        }
        return this.orderInterface.editOrderProducts(editOrderAddressDTO.getOrderNo(), productList, Boolean.valueOf(true));
    }

    public BaseJsonVo<String> editDeliverDateByForce(String externalOrderNo, String pickupDate, String deliverDate) {
        if (StringUtils.isEmpty((String)externalOrderNo)) {
            return BaseJsonVo.success((Object)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)pickupDate) && StringUtils.isEmpty((String)deliverDate)) {
            return BaseJsonVo.success((Object)"\u4e24\u4e2a\u65e5\u671f\u90fd\u4e3a\u7a7a\uff0c\u76f4\u63a5\u8fd4\u56de\u6210\u529f");
        }
        Date thePickupDate = null;
        if (StringUtils.isNotEmpty((String)pickupDate) && (thePickupDate = DateUtils.getDateFromString((String)pickupDate, null)) == null) {
            return BaseJsonVo.error((String)"pickupDate\u683c\u5f0f\u9519\u8bef");
        }
        Date theDeliverDate = null;
        if (StringUtils.isNotEmpty((String)deliverDate) && (theDeliverDate = DateUtils.getDateFromString((String)deliverDate, null)) == null) {
            return BaseJsonVo.error((String)"deliverDate\u683c\u5f0f\u9519\u8bef");
        }
        return this.orderInterface.editOrderDeliverDateByForce(externalOrderNo, thePickupDate, theDeliverDate);
    }

    public BaseJsonVo<String> refundOrderStatusByForce(String orderNo, Integer refundAll, Integer orderStatus) {
        if (StringUtils.isEmpty((String)orderNo)) {
            return BaseJsonVo.error((String)"\u5b50\u8ba2\u5355\u53f7orderNo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (refundAll == null || refundAll != 0 && refundAll != 1) {
            return BaseJsonVo.error((String)"\u662f\u5426\u9000\u4e3b\u5355\u7684\u6807\u8bc6refundAll\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u53ea\u80fd\u4e3a[0\u4e0d\u9000\u4e3b\u5355]\u6216[1\u9000\u4e3b\u5355]");
        }
        if (orderStatus == null || orderStatus != 20 && orderStatus != 26 && orderStatus != 27) {
            return BaseJsonVo.error((String)"\u9000\u6b3e\u72b6\u6001\u6807\u8bc6orderStatus\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u53ea\u80fd\u4e3a[20\u4e0d\u9000\u4e3b\u5355]\u6216[26\u9000\u6b3e\u5904\u7406\u4e2d]\u6216[27\u9000\u6b3e\u5b8c\u6210]");
        }
        return this.orderInterface.refundOrderStatusByForce(orderNo, refundAll, orderStatus);
    }

    @Transactional
    public BaseJsonVo<String> refundProducts(@RequestBody List<RefundProductDTO> products) {
        if (products == null || products.size() == 0) {
            return BaseJsonVo.error((String)"\u8981\u9000\u7684\u5546\u54c1\u4e3a\u7a7a");
        }
        String[] errMsg = new String[]{""};
        products.forEach(productDTO -> {
            if (productDTO.getRefundCount() == null || productDTO.getRefundAmount() == null) {
                errMsg[0] = "\u8fd9\u6761\u5fc5\u4f20refundCount\u548crefundAmount[" + JsonUtils.toJson((Object)productDTO, (boolean)false) + "]";
                return;
            }
            if (StringUtils.isNotEmpty((String)productDTO.getOrderProductId())) {
                MallOrderGroupProductEntity orderProduct = this.mallOrderGroupProductInterface.getOrderGroupProductByID(productDTO.getOrderProductId());
                if (orderProduct != null) {
                    orderProduct.setRefundCount(Integer.valueOf(orderProduct.getRefundCount() + productDTO.getRefundCount()));
                    orderProduct.setRefundAmount(orderProduct.getRefundAmount().add(productDTO.getRefundAmount()));
                    this.mallOrderGroupProductInterface.updateOrderGroupProductByID(orderProduct);
                    if (orderProduct.getGroupType() == 2 && orderProduct.getRefundCount() >= orderProduct.getQuantity()) {
                        List orderGroupProductList = this.mallOrderGroupProductInterface.getOrderGroupProductList(orderProduct.getOrderProductNo());
                        Boolean[] refundAll = new Boolean[]{true};
                        orderGroupProductList.forEach(orderGroupProduct -> {
                            if (!orderGroupProduct.getOrderGroupId().equals(orderProduct.getOrderGroupId()) && orderGroupProduct.getRefundCount() < orderGroupProduct.getQuantity()) {
                                refundAll[0] = false;
                            }
                        });
                        if (refundAll[0].booleanValue()) {
                            MallOrderProductEntity orderGroup = this.mallOrderProductInterface.getOrderProductByID(orderProduct.getOrderProductNo());
                            orderGroup.setRefundCount(orderGroup.getQuantity());
                            orderGroup.setRefundAmount(orderGroup.getTotalPrice());
                            this.mallOrderProductInterface.updateOrderProductByID(orderGroup);
                        }
                    } else if (orderProduct.getGroupType() == 4) {
                        MallOrderProductEntity orderGroup = this.mallOrderProductInterface.getOrderProductByID(orderProduct.getOrderProductNo());
                        orderGroup.setRefundCount(Integer.valueOf(orderGroup.getRefundCount() + productDTO.getRefundCount()));
                        orderGroup.setRefundAmount(orderGroup.getRefundAmount().add(productDTO.getRefundAmount()));
                        this.mallOrderProductInterface.updateOrderProductByID(orderGroup);
                    }
                }
            } else if (StringUtils.isNotEmpty((String)productDTO.getOrderNo()) && StringUtils.isNotEmpty((String)productDTO.getProductId())) {
                List orderProducts = this.mallOrderGroupProductInterface.getOrderGroupProductListByOrderNoAndProductId(productDTO.getOrderNo(), productDTO.getProductId());
                int areadyRefundCount = 0;
                BigDecimal areadyRefundAmount = BigDecimal.ZERO;
                for (MallOrderGroupProductEntity orderProduct : orderProducts) {
                    Boolean breakflag = false;
                    if (orderProduct.getQuantity() >= productDTO.getRefundCount() - areadyRefundCount) {
                        orderProduct.setRefundCount(Integer.valueOf(orderProduct.getRefundCount() + productDTO.getRefundCount() - areadyRefundCount));
                        orderProduct.setRefundAmount(orderProduct.getRefundAmount().add(orderProduct.getUnitPrice().multiply(new BigDecimal(productDTO.getRefundCount() - areadyRefundCount)).setScale(6, 4)));
                        breakflag = true;
                    } else {
                        orderProduct.setRefundCount(Integer.valueOf(orderProduct.getRefundCount() + productDTO.getRefundCount()));
                        orderProduct.setRefundAmount(orderProduct.getRefundAmount().add(orderProduct.getUnitPrice().multiply(new BigDecimal(orderProduct.getQuantity())).setScale(6, 4)));
                    }
                    this.mallOrderGroupProductInterface.updateOrderGroupProductByID(orderProduct);
                    if (orderProduct.getGroupType() == 2 && orderProduct.getRefundCount() >= orderProduct.getQuantity()) {
                        List orderGroupProductList = this.mallOrderGroupProductInterface.getOrderGroupProductList(orderProduct.getOrderProductNo());
                        Boolean[] refundAll = new Boolean[]{true};
                        orderGroupProductList.forEach(orderGroupProduct -> {
                            if (!orderGroupProduct.getOrderGroupId().equals(orderProduct.getOrderGroupId()) && orderGroupProduct.getRefundCount() < orderGroupProduct.getQuantity()) {
                                refundAll[0] = false;
                            }
                        });
                        if (refundAll[0].booleanValue()) {
                            MallOrderProductEntity orderGroup = this.mallOrderProductInterface.getOrderProductByID(orderProduct.getOrderProductNo());
                            orderGroup.setRefundCount(orderGroup.getQuantity());
                            orderGroup.setRefundAmount(orderGroup.getTotalPrice());
                            this.mallOrderProductInterface.updateOrderProductByID(orderGroup);
                        }
                    } else if (orderProduct.getGroupType() == 4) {
                        MallOrderProductEntity orderGroup = this.mallOrderProductInterface.getOrderProductByID(orderProduct.getOrderProductNo());
                        orderGroup.setRefundCount(Integer.valueOf(orderGroup.getRefundCount() + productDTO.getRefundCount()));
                        orderGroup.setRefundAmount(orderGroup.getRefundAmount().add(productDTO.getRefundAmount()));
                        this.mallOrderProductInterface.updateOrderProductByID(orderGroup);
                    }
                    if (!breakflag.booleanValue()) continue;
                    break;
                }
            } else {
                errMsg[0] = "\u9000\u5546\u54c1\u53c2\u6570\u6709\u8bef\uff0c\u6ca1\u6709\u8fd9\u79cd\u7b56\u7565";
            }
        });
        if (errMsg == null || errMsg.length == 0 || "".equals(errMsg[0])) {
            return BaseJsonVo.success((Object)"\u66f4\u65b0\u6210\u529f");
        }
        return BaseJsonVo.error((String)errMsg[0]);
    }
}

