/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.api;

import cc.lechun.framework.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mallapi.api.OrderSyncApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class OrderSyncApiService
implements OrderSyncApi {
    @Autowired
    MallOrderSyncInfoInterface orderSyncInfoInterface;

    public BaseJsonVo<String> syncOrderToOMS(String orderMainNo) {
        BaseJsonVo baseJsonVo = this.orderSyncInfoInterface.syncToOMS(orderMainNo);
        if (baseJsonVo.isSuccess()) {
            return BaseJsonVo.success((Object)("[" + orderMainNo + "]\u540c\u6b65\u5b8c\u6210"));
        }
        return baseJsonVo;
    }

    public BaseJsonVo<String> orderStatusSyncToOMS(@RequestParam(value="orderMainNo") String orderMainNo, @RequestParam(value="orderNo") String orderNo, @RequestParam(value="orderStatus") Integer orderStatus) {
        if (StringUtils.isEmpty((String)orderMainNo)) {
            return BaseJsonVo.error((String)"\u4e3b\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u5b50\u8ba2\u5355\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (orderStatus == null) {
            return BaseJsonVo.error((String)(orderMainNo + " \u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        OrderStatusEnum[] orderStatusEnum = new OrderStatusEnum[]{null};
        OrderStatusEnum.getList().forEach(status -> {
            if (status.getValue() == orderStatus.intValue()) {
                orderStatusEnum[0] = status;
            }
        });
        if (orderStatusEnum[0] == null) {
            return BaseJsonVo.error((String)(orderMainNo + " \u8ba2\u5355\u72b6\u6001\u4e0d\u5b58\u5728\uff0c\u8bf7\u53c2\u8003OrderStatusEnum\u7c7b"));
        }
        BaseJsonVo baseJsonVo = this.orderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, orderStatusEnum[0]);
        if (baseJsonVo.isSuccess()) {
            return BaseJsonVo.success((Object)("[" + orderMainNo + "]\u540c\u6b65\u5b8c\u6210"));
        }
        return baseJsonVo;
    }
}

