/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.prepay;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.prepay.PrepayCardDo;
import cc.lechun.mall.entity.prepay.PrepayCardEntity;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import com.github.pagehelper.util.StringUtil;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"prepay"})
public class PrepayController {
    @Autowired
    private PrepayCardPlanDetailInterface planDetailInterface;
    @Autowired
    private PrepayCardOrderPlanInterface prepayCardOrderPlanService;
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private PrepayCardInterface cardInterface;
    @Autowired
    private CustomerAddressInterface addressService;

    @RequestMapping(value={"createPlanOrder"})
    public BaseJsonVo createPlanOrder(String date) throws InvalidKeySpecException, NoSuchAlgorithmException {
        if (StringUtil.isEmpty((String)date)) {
            this.planDetailInterface.createPlanOrder(DateUtils.currentDate());
        } else {
            this.planDetailInterface.createPlanOrder(DateUtils.getDateFromString((String)date, (String)"yyyy-MM-dd"));
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"getOrderPlanList"})
    public BaseJsonVo getOrderPlanList(String orderMainNo) {
        return this.prepayCardOrderPlanService.getOrderPlanList(orderMainNo);
    }

    @RequestMapping(value={"getCardInfo"})
    public BaseJsonVo getCardInfo(String orderMainNo) {
        return this.prepayCardOrderPlanService.getCardInfo(orderMainNo);
    }

    @RequestMapping(value={"refundOrderPlan"})
    public BaseJsonVo refundOrderPlan(String orderMainNo, Integer orderSource, String planIds, BigDecimal amount, String operator) {
        return this.prepayCardOrderPlanService.refundOrderPlan(orderMainNo, orderSource.intValue(), planIds, amount, operator);
    }

    @RequestMapping(value={"getMyCardList"})
    public BaseJsonVo getMyCardList() throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getMyCardList(customerDetailVo.getCustomerId()));
    }

    @RequestMapping(value={"getCardList"})
    public BaseJsonVo getCardList(Integer cardStatus) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getCardList(customerDetailVo.getCustomerId(), Integer.valueOf(cardStatus == null ? 1 : cardStatus)));
    }

    @RequestMapping(value={"getBuyCardList"})
    public BaseJsonVo getBuyCardList() throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getBuyCardList(customerDetailVo.getCustomerId(), customerDetailVo.getPlatformGroupId().intValue()));
    }

    @RequestMapping(value={"getHistoryCardList"})
    public BaseJsonVo getHistoryCardList(Integer cardStatus) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getHistoryCardList(customerDetailVo.getCustomerId(), cardStatus));
    }

    @RequestMapping(value={"getFirstDeliveryDate"})
    public BaseJsonVo getFirstDeliveryDate(PrepayCardEntity prepayCardEntity) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        prepayCardEntity.setBelongCustomerId(customerDetailVo.getCustomerId());
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getFirstDeliveryDate(prepayCardEntity.getPeriodType().intValue(), prepayCardEntity.getPeriod()));
    }

    @RequestMapping(value={"saveOrderPlanDetailed"})
    public BaseJsonVo saveOrderPlanDetailed(PrepayCardDo prepayCardDo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.prepayCardOrderPlanService.saveOrderPlan(prepayCardDo, customerDetailVo.getCustomerId());
    }

    @RequestMapping(value={"deleteOrderPlan"})
    public BaseJsonVo deleteOrderPlan(Integer detailedId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.prepayCardOrderPlanService.deleteOrderPlan(detailedId, customerDetailVo.getCustomerId());
    }

    @RequestMapping(value={"createPlanOrderTest"})
    public BaseJsonVo createPlanOrder_test(String cardId) {
        return this.planDetailInterface.createPlanOrder(cardId, 1);
    }

    @RequestMapping(value={"saveDeliveryRule"})
    public BaseJsonVo saveDeliveryRule(PrepayCardDo prepayCardDo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        int platformId = this.customerLoginService.getPlatFormId();
        BaseJsonVo baseJsonVo = this.prepayCardOrderPlanService.saveDeliverRule(prepayCardDo, platformId);
        if (baseJsonVo.isSuccess()) {
            this.planDetailInterface.createPlanOrder(prepayCardDo.getCardId(), platformId);
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"suspendDeliveryPlan"})
    public BaseJsonVo suspendDeliveryPlan(String cardId) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.prepayCardOrderPlanService.suspendDeliveryPlan(cardId);
    }

    @RequestMapping(value={"getCardPlanDetail"})
    public BaseJsonVo getCardPlanDetail(HttpServletRequest request, String cardId) throws AuthorizeException, Exception {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.prepayCardOrderPlanService.getCardPlanDetail(customerDetailVo.getCustomerId(), cardId);
    }

    @RequestMapping(value={"test112"})
    public BaseJsonVo orderPaySuccessUpdateCardPlanStatus(Integer num, String cardId) {
        for (int i = 0; i < num; ++i) {
            this.planDetailInterface.createPlanOrder(cardId, 1);
        }
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"exchange"})
    public BaseJsonVo exchange(String card) throws AuthorizeException {
        if (StringUtils.isEmpty((String)card)) {
            return BaseJsonVo.error((String)"\u8bf7\u8f93\u5165\u5361\u5bc6");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.cardInterface.exchange(customerDetailVo.getCustomerId(), card);
    }

    @RequestMapping(value={"testCardMyList"})
    public BaseJsonVo testCardMyList(String customerId, Integer cardUseStatus) {
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getCardList(customerId, cardUseStatus));
    }

    @RequestMapping(value={"testBuyCardList"})
    public BaseJsonVo testBuyCardList(String customerId) {
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getBuyCardList(customerId, 1000));
    }

    @RequestMapping(value={"testHistoryCardList"})
    public BaseJsonVo testHistoryCardList(String customerId, Integer cardStatus) {
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.getHistoryCardList(customerId, cardStatus));
    }

    @RequestMapping(value={"testSaveRule"})
    public BaseJsonVo testSaveRule(PrepayCardDo prepayCardDo) {
        return BaseJsonVo.success((Object)this.prepayCardOrderPlanService.saveDeliverRule(prepayCardDo, 1));
    }

    @RequestMapping(value={"testPushMessage"})
    public BaseJsonVo testPushMessage(Integer num, String cardId) {
        this.cardInterface.pushFinshMessage();
        this.cardInterface.pushActivedMessage();
        this.cardInterface.pushProcessMessage();
        this.cardInterface.pushExpiredMessage();
        return BaseJsonVo.success((Object)"");
    }
}

