/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.shoppingcart;

import cc.lechun.common.enums.sync.DataSyncTypeEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.web.IpUtil;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerAddressVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.customer.CustomerAddressInterface;
import cc.lechun.mall.iservice.reunion.ReunionProductInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.weixin.MiniApiInterface;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"shoppingcart"})
public class MallShoppingcartController {
    private static final Logger log = LoggerFactory.getLogger(MallShoppingcartController.class);
    @Autowired
    MallShoppingcartInterface cartService;
    @Autowired
    CustomerLoginService customerLoginService;
    @Autowired
    CustomerAddressInterface addressService;
    @Autowired
    MallDataSyncInterface dataSyncInterface;
    @Autowired
    MiniApiInterface miniApiInterface;
    @Autowired
    MallOrderSyncInfoInterface mallOrderSyncInfoInterface;
    @Autowired
    ReunionProductInterface reunionProductInterface;

    @RequestMapping(value={"cartCountWithSaleId"})
    public BaseJsonVo cartCountWithSaleId(HttpServletRequest request, String saleId) throws Exception {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        if (customer == null) {
            BaseJsonVo cartSR = this.cartService.buildEmptyCart();
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        BaseJsonVo cartSR = this.cartService.buildCartCountWithSaleId(customer.getPlatformId(), customer.getCustomerId(), saleId);
        if (cartSR.isSuccess()) {
            log.info("=-=-=-=-=-=-=-=\u8d2d\u7269\u8f66\u6570\u91cf\u8fd4\u56de\u53c2\u6570======={}", cartSR.getValue());
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        return BaseJsonVo.error((String)cartSR.getError_msg());
    }

    @RequestMapping(value={"cartCount"})
    public BaseJsonVo cartCount(HttpServletRequest request) throws Exception {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        if (customer == null) {
            BaseJsonVo cartSR = this.cartService.buildEmptyCart();
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        BaseJsonVo cartSR = this.cartService.buildCartCount(customer.getPlatformId(), customer.getCustomerId());
        if (cartSR.isSuccess()) {
            log.info("=-=-=-=-=-=-=-=\u8d2d\u7269\u8f66\u6570\u91cf\u8fd4\u56de\u53c2\u6570======={}", cartSR.getValue());
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        return BaseJsonVo.error((String)cartSR.getError_msg());
    }

    @RequestMapping(value={"cartListCount"})
    public BaseJsonVo cartListCount(HttpServletRequest request) throws Exception {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        if (customer == null) {
            BaseJsonVo cartSR = this.cartService.buildEmptyCart();
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        BaseJsonVo cartSR = this.cartService.buildCartListCount(customer.getPlatformId(), customer.getCustomerId());
        if (cartSR.isSuccess()) {
            log.info("=-=-=-=-=-=-=-=\u8d2d\u7269\u8f66\u6570\u91cf\u8fd4\u56de\u53c2\u6570======={}", cartSR.getValue());
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        return BaseJsonVo.error((String)cartSR.getError_msg());
    }

    @RequestMapping(value={"cartList"})
    public BaseJsonVo cartList(HttpServletRequest request, String areaId, String address, String needLogin, Boolean isQuick) throws Exception {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(false);
        if (customer == null && "0".equals(needLogin)) {
            BaseJsonVo cartSR = this.cartService.buildEmptyCart();
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        if (customer == null && !"0".equals(needLogin)) {
            throw new AuthorizeException("\u7528\u6237\u672a\u767b\u9646");
        }
        CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress(customer.getCustomerId(), areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
        BaseJsonVo cartSR = this.cartService.buildCart(customer.getPlatformId(), customer.getCustomerId(), addressVo, isQuick);
        if (cartSR.isSuccess()) {
            log.info("=-=-=-=-=-=-=-=\u8d2d\u7269\u8f66\u8fd4\u56de\u53c2\u6570======={}", cartSR.getValue());
            return BaseJsonVo.success((Object)cartSR.getValue());
        }
        return BaseJsonVo.error((String)cartSR.getError_msg());
    }

    @RequestMapping(value={"checkCart"})
    public BaseJsonVo checkCart(HttpServletRequest request, Integer checkType, String salesId, String areaId, String address) throws Exception {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        BaseJsonVo result = this.cartService.checkCart(customer.getPlatformId(), customer.getCustomerId(), checkType, salesId);
        if (result.isSuccess()) {
            int[] transportType = new int[]{1};
            CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress(customer.getCustomerId(), areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
            BaseJsonVo cartSR = this.cartService.buildCart(customer.getPlatformId(), customer.getCustomerId(), addressVo, Boolean.valueOf(false));
            if (cartSR.isSuccess()) {
                return BaseJsonVo.success((Object)cartSR.getValue());
            }
            return BaseJsonVo.error((String)cartSR.getError_msg());
        }
        return BaseJsonVo.error((String)result.getError_msg());
    }

    @RequestMapping(value={"addCart"})
    public BaseJsonVo addCart(HttpServletRequest request, Integer salesType, String salesId, String activeNo, Integer quantity, String areaId, String address, Boolean isQuick) throws AuthorizeException, Exception {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        if (quantity == 0) {
            return BaseJsonVo.success((Object)"");
        }
        BaseJsonVo addResult = this.cartService.addCart(customer.getPlatformId(), customer.getCustomerId(), salesType, salesId, activeNo, quantity, isQuick);
        if (addResult.isSuccess()) {
            this.dataSyncInterface.producerData(customer.getCustomerId(), DataSyncTypeEnum.BI_CART, "\u8d2d\u7269\u8f66\u540c\u6b65");
            int[] transportType = new int[]{1};
            CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress(customer.getCustomerId(), areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
            BaseJsonVo cartSR = this.cartService.buildCart(customer.getPlatformId(), customer.getCustomerId(), addressVo, isQuick);
            if (cartSR.isSuccess()) {
                return BaseJsonVo.success((Object)cartSR.getValue());
            }
            return BaseJsonVo.error((String)cartSR.getError_msg());
        }
        return BaseJsonVo.error((String)addResult.getError_msg());
    }

    @RequestMapping(value={"removeCartProduct"})
    public BaseJsonVo removeCartProduct(HttpServletRequest request, String salesId, String areaId, String address, Boolean isQuick) throws AuthorizeException, Exception {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        BaseJsonVo removeResult = this.cartService.removeCartProduct(customer.getCustomerId(), salesId);
        if (removeResult.isSuccess()) {
            this.dataSyncInterface.producerData(customer.getCustomerId(), DataSyncTypeEnum.BI_CART, "\u8d2d\u7269\u8f66\u540c\u6b65");
            int[] transportType = new int[]{1};
            CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress(customer.getCustomerId(), areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
            BaseJsonVo cartSR = this.cartService.buildCart(customer.getPlatformId(), customer.getCustomerId(), addressVo, Boolean.valueOf(false));
            if (cartSR.isSuccess()) {
                return BaseJsonVo.success((Object)cartSR.getValue());
            }
            return BaseJsonVo.error((String)cartSR.getError_msg());
        }
        return BaseJsonVo.error((String)removeResult.getError_msg());
    }

    @RequestMapping(value={"removeCartInvalid"})
    public BaseJsonVo removeCartInvalid(HttpServletRequest request, String areaId, String address) throws AuthorizeException, Exception {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        BaseJsonVo removeResult = this.cartService.removeCartInvalid(customer.getPlatformId(), customer.getCustomerId());
        if (removeResult.isSuccess()) {
            this.dataSyncInterface.producerData(customer.getCustomerId(), DataSyncTypeEnum.BI_CART, "\u8d2d\u7269\u8f66\u540c\u6b65");
            int[] transportType = new int[]{1};
            CustomerAddressVo addressVo = this.addressService.getCustomerDefaultAddress(customer.getCustomerId(), areaId, address, IpUtil.getCliectIp((HttpServletRequest)request), null);
            BaseJsonVo cartSR = this.cartService.buildCart(customer.getPlatformId(), customer.getCustomerId(), addressVo, Boolean.valueOf(false));
            if (cartSR.isSuccess()) {
                return BaseJsonVo.success((Object)cartSR.getValue());
            }
            return BaseJsonVo.error((String)cartSR.getError_msg());
        }
        return BaseJsonVo.error((String)removeResult.getError_msg());
    }

    @RequestMapping(value={"addOnProducts"})
    public BaseJsonVo addOnProducts(Integer selfMadeType) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        BaseJsonVo products = this.cartService.findAddOnProducts(customer.getPlatformId(), customer.getCustomerId(), selfMadeType);
        if (products.isSuccess()) {
            this.dataSyncInterface.producerData(customer.getCustomerId(), DataSyncTypeEnum.BI_CART, "\u8d2d\u7269\u8f66\u540c\u6b65");
            return BaseJsonVo.success((Object)products.getValue());
        }
        return BaseJsonVo.error((String)products.getError_msg());
    }

    @RequestMapping(value={"findRecommends"})
    public BaseJsonVo findRecommends() throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        List sales = this.cartService.findRecommends(customer.getPlatformGroupId());
        if (sales != null && sales.size() > 0) {
            return BaseJsonVo.success((Object)sales);
        }
        return BaseJsonVo.success((String)"\u65e0\u63a8\u8350\u5546\u54c1", null);
    }

    @RequestMapping(value={"test"})
    public BaseJsonVo test(Integer platFormId, String content, String orderMainNo, String orderNo, String type, String editHistoryId) {
        if ("1".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, OrderStatusEnum.DELETE);
        }
        if ("2".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, OrderStatusEnum.PAYCONFIRM);
        }
        if ("3".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, OrderStatusEnum.CANCEL);
        }
        if ("4".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderStatus(orderMainNo, orderNo, OrderStatusEnum.COMPLETION);
        }
        if ("5".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderModifyOrder(orderNo, Integer.valueOf(1));
        }
        if ("6".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrder(orderMainNo, orderNo);
        }
        if ("7".equals(type)) {
            return this.mallOrderSyncInfoInterface.toDetailOrderModifyProducts(orderNo, editHistoryId);
        }
        if ("8".equals(type)) {
            return this.mallOrderSyncInfoInterface.syncOrder(orderNo);
        }
        if ("9".equals(type)) {
            return this.reunionProductInterface.recoveryList(orderMainNo, orderNo);
        }
        return BaseJsonVo.success(null);
    }
}

