/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.common;

import cc.lechun.active.entity.Cash.CustomerCashVo;
import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.entity.active.ActivePageVo;
import cc.lechun.active.entity.active.ActiveQrcodeEntity;
import cc.lechun.active.iservice.active.ActiveCashticketInterface;
import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.iservice.active.ActiveIndexInterface;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActivePropertyInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.active.iservice.shortlink.ShortLinkInterface;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.common.file.OssService;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.InteractionDetailEntity;
import cc.lechun.mall.entity.distribution.ActiveGiftPropertyInfoVo;
import cc.lechun.mall.entity.distribution.DistributionInviteLogEntity;
import cc.lechun.mall.entity.distribution.DistributorRelationEntity;
import cc.lechun.mall.iservice.customer.CustomerAdCookieInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.InteractionDetailInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteInterface;
import cc.lechun.mall.iservice.distribution.DistributionInviteLogInterface;
import cc.lechun.mall.iservice.distribution.DistributorGrowthActiveInterface;
import cc.lechun.mall.iservice.distribution.DistributorRelationInterface;
import cc.lechun.mall.iservice.distribution.ShareInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.shortlink.UrlVisitInterface;
import cc.lechun.mall.iservice.weixin.TemplateMessageInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/active"})
public class ActiveCommonController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private ActiveQrcodeInterface activeQrcodeService;
    @Autowired
    private OssService ossService;
    @Autowired
    private ActiveCommonInterface activeCommonService;
    @Autowired
    private ActiveCashticketInterface activeCashticketInterface;
    @Autowired
    private ShortLinkInterface shortLinkService;
    @Autowired
    ShareInterface shareInterface;
    @Autowired
    DistributorRelationInterface distributorRelationInterface;
    @Autowired
    DistributionInviteInterface distributionInviteInterface;
    @Autowired
    DistributionInviteLogInterface distributionInviteLogInterface;
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private MallProductPicInterface picInterface;
    @Autowired
    private ActiveIndexInterface activeIndexInterface;
    @Autowired
    private CustomerAdCookieInterface customerAdCookieInterface;
    @Autowired
    private UrlVisitInterface urlVisitInterface;
    @Autowired
    private InteractionDetailInterface interactionDetailInterface;
    @Autowired
    private ActivePropertyInterface activePropertyInterface;
    @Autowired
    DistributorGrowthActiveInterface distributorGrowthActiveInterface;
    @Autowired
    TemplateMessageInterface templateMessageInterface;

    @RequestMapping(value={"/getActiveIndexList"})
    public BaseJsonVo getActiveIndexList(HttpServletRequest request, PageForm pageForm) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return BaseJsonVo.success((Object)this.activeIndexInterface.getActiveIndexList(pageForm, customerDetailVo.getPlatformGroupId()));
    }

    @RequestMapping(value={"/getTestActiveIndexList"})
    public BaseJsonVo getTestActiveIndexList(HttpServletRequest request, PageForm pageForm) throws AuthorizeException {
        return BaseJsonVo.success((Object)this.activeIndexInterface.getActiveIndexList(pageForm, Integer.valueOf(1000)));
    }

    @RequestMapping(value={"/getShare"})
    public BaseJsonVo getShareByBindCode(HttpServletRequest request, HttpServletResponse response, String bindCode, String productId, Integer groupType, String adCookie, String gdt_vid, String dataSource, Integer itemType, String itemId, String referer, String orderNo, Integer orderSource) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(false);
        String pageUrl = referer;
        if (StringUtils.isEmpty((String)pageUrl)) {
            referer = request.getHeader("referer");
        }
        this.logger.info("pageUrl:" + pageUrl);
        if (StringUtils.isNotEmpty((String)adCookie) || StringUtils.isNotEmpty((String)gdt_vid)) {
            try {
                this.customerAdCookieInterface.saveAdCookieCustomerInfo(customerDetailVo.getCustomerId(), adCookie, gdt_vid, Integer.valueOf(StringUtils.isNotEmpty((String)dataSource) ? Integer.valueOf(dataSource) : 0), itemType, itemId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"\u6ca1\u6709\u5206\u4eab\u914d\u7f6e");
        if (customerDetailVo != null && StringUtils.isNotEmpty((String)customerDetailVo.getCustomerId())) {
            String customerId = customerDetailVo.getCustomerId();
            String nickName = customerDetailVo.getNickName();
            String inviteCode = "";
            DistributorRelationEntity distributorRelation = this.distributorRelationInterface.getDistributorRelationByRelationUserId(customerDetailVo.getCustomerId(), Integer.valueOf(1));
            if (distributorRelation != null && StringUtils.isNotEmpty((String)distributorRelation.getDistributorRelationCode())) {
                inviteCode = distributorRelation.getDistributorRelationCode();
            }
            if (StringUtils.isNotEmpty((String)bindCode)) {
                baseJsonVo = this.activeCommonService.getActiveShare(pageUrl, bindCode, inviteCode, customerId, nickName, productId, orderNo);
                if (baseJsonVo.isSuccess()) {
                    if (platformId != 4) {
                        BaseJsonVo isNewUser = this.activeCommonService.checkIsNewUser(customerDetailVo.getOpenId(), Integer.valueOf(platformId), bindCode);
                        ((Map)baseJsonVo.getValue()).putAll((Map)isNewUser.getValue());
                    } else {
                        ActiveQrcodeEntity activeQrcodeEntity;
                        HashMap<String, String> map = new HashMap<String, String>();
                        CustomerDetailVo customerDetail = this.customerInterface.getCustomerDetail(customerDetailVo.getCustomerId(), 1);
                        map.put("userStatus", customerDetail == null ? "0" : String.valueOf(customerDetail.getSubscribe() == 1 ? 1 : 0));
                        map.put("qrcodeUrl", "");
                        if (StringUtils.isNotEmpty((String)bindCode) && (activeQrcodeEntity = this.activeQrcodeService.getActiveQrcode(bindCode)) != null) {
                            map.put("qrcodeUrl", this.ossService.getImageResoure(activeQrcodeEntity.getQrcodeImageUrl()));
                        }
                        ((Map)baseJsonVo.getValue()).putAll(map);
                    }
                } else {
                    baseJsonVo = this.shareInterface.getShare(pageUrl, inviteCode, customerId, nickName, productId, groupType, platformId);
                }
            } else {
                baseJsonVo = this.shareInterface.getShare(pageUrl, inviteCode, customerId, nickName, productId, groupType, platformId);
            }
            this.logger.info("\u5206\u4eab\u8fd4\u56de\uff1a{}", (Object)JsonUtils.toJson((Object)baseJsonVo.getValue(), (boolean)false));
            if (!baseJsonVo.isSuccess()) {
                baseJsonVo = this.shareInterface.getDefaultShare(pageUrl, inviteCode, customerId, nickName, productId, groupType);
            }
        } else {
            baseJsonVo = this.shareInterface.getShare(pageUrl, "", "", "", productId, groupType, platformId);
            if (!baseJsonVo.isSuccess()) {
                baseJsonVo = this.shareInterface.getDefaultShare(pageUrl, "", "", "\u4e50\u7eaf\u7528\u6237", productId, groupType);
                if (platformId == 4) {
                    ((Map)baseJsonVo.getValue()).put("url", "");
                }
            }
        }
        if (baseJsonVo.isSuccess() && StringUtils.isNotEmpty((String)pageUrl)) {
            pageUrl = pageUrl.split("\\?")[0];
            this.logger.info("pageUrl={},platformId={},bindCode={},orderSource={}", new Object[]{pageUrl, platformId, bindCode, orderSource});
            ((Map)baseJsonVo.getValue()).put("scribeTemplates", this.templateMessageInterface.getTempMessageListByPage(pageUrl, Integer.valueOf(platformId), bindCode, orderSource));
            if (customerDetailVo != null && StringUtils.isNotEmpty((String)customerDetailVo.getCustomerId())) {
                String nickName = customerDetailVo.getNickName();
                ((Map)baseJsonVo.getValue()).put("nickName", StringUtils.isEmpty((String)nickName) ? "\u5fae\u4fe1\u7528\u6237" : nickName);
                ((Map)baseJsonVo.getValue()).put("headImageUrl", StringUtils.isEmpty((String)customerDetailVo.getHeadImageUrl()) ? "https://thirdwx.qlogo.cn/mmopen/vi_32/POgEwh4mIHO4nibH0KlMECNjjGxQUq24ZEaGT4poC6icRiccVGKSyXwibcPq4BWmiaIGuG1icwxaQX6grC9VemZoJ8rg/132" : customerDetailVo.getHeadImageUrl());
            }
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"/getShareTest"})
    public BaseJsonVo getShareByBindCodeTest(HttpServletRequest request, HttpServletResponse response, String bindCode, String productId, Integer groupType, String adCookie, String gdt_vid, String dataSource, Integer itemType, String itemId, String referer, String orderNo) throws AuthorizeException {
        return this.activeCommonService.getActiveShare("https://lechun.cc/recover_share?bindCode=3388568617416895240&ncp_bat=&inviteId=10003355426914989387637", bindCode, "", "10003355426914989387638", "\u6d6a\u82b1", "", "");
    }

    @RequestMapping(value={"/checkIsNewUser"})
    public BaseJsonVo checkIsNewUser(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.activeCommonService.checkIsNewUser(customerDetailVo.getOpenId(), Integer.valueOf(1), bindCode);
    }

    @RequestMapping(value={"/checkUserSubscribe"})
    public BaseJsonVo checkUserSubscribe() throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.activeCommonService.checkUserSubscribe(customerDetailVo.getCustomerId(), Integer.valueOf(1));
    }

    @RequestMapping(value={"/sendCashticket"})
    public BaseJsonVo sendcashticket(HttpServletRequest httpServletRequest, String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        int platformId = this.customerLoginService.getPlatFormId();
        return this.activeCashticketInterface.sendCashticket(httpServletRequest, customerDetailVo.getPlatformGroupId(), Integer.valueOf(platformId), Integer.valueOf(customerDetailVo.getSubscribe()), bindCode, customerDetailVo.getCustomerId());
    }

    @RequestMapping(value={"/sendCash"})
    public BaseJsonVo sendCash(HttpServletRequest httpServletRequest, String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        int platformId = this.customerLoginService.getPlatFormId();
        HashMap map = new HashMap();
        BaseJsonVo baseJsonVo = this.activeCashticketInterface.sendTicket4CustomerType(customerDetailVo.getCustomerId(), bindCode, "", Integer.valueOf(platformId), customerDetailVo.getPlatformGroupId(), true, Integer.valueOf(1));
        if (!baseJsonVo.isSuccess()) {
            CustomerCashVo customerCashVo = new CustomerCashVo();
            customerCashVo.setSubscribe(this.activeCommonService.checkIsNewUser(customerDetailVo.getOpenId(), customerDetailVo.getPlatformId()));
            return BaseJsonVo.success((Object)customerCashVo);
        }
        CustomerCashVo customerCashVo = (CustomerCashVo)baseJsonVo.getValue();
        customerCashVo.setSubscribe(this.activeCommonService.checkIsNewUser(customerDetailVo.getOpenId(), customerDetailVo.getPlatformId()));
        baseJsonVo.setValue((Object)customerCashVo);
        return baseJsonVo;
    }

    @RequestMapping(value={"/testSendCashticket"})
    public BaseJsonVo testSendCashticket(HttpServletRequest httpServletRequest, String bindCode) {
        BaseJsonVo jsonVo = this.activeCashticketInterface.sendTicket4CustomerType("10003355426914989387638", bindCode, "", Integer.valueOf(1), Integer.valueOf(1000), true, Integer.valueOf(1));
        return jsonVo;
    }

    @RequestMapping(value={"/getLink"})
    public void getLink(HttpServletRequest request, HttpServletResponse response, String link, String referer) throws IOException {
        if (StringUtils.isNotEmpty((String)link)) {
            link = link.replace("/", "");
            String shortLink = this.shortLinkService.getMallUrl(link);
            String ua = request.getHeader("User-Agent");
            String ip = request.getHeader("x-forwarded-for");
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
            if (StringUtils.isNotEmpty((String)shortLink)) {
                this.urlVisitInterface.saveUrlVisit(ua, ip, link, referer);
            }
            response.sendRedirect(StringUtils.isNotEmpty((String)shortLink) ? shortLink : "https://wx.lechun.cc");
            return;
        }
        response.sendRedirect("https://wx.lechun.cc");
    }

    @RequestMapping(value={"/getShortLink"})
    public String getShortLink(String link) throws AuthorizeException, IOException {
        return this.shortLinkService.getShorterUrl(link);
    }

    @RequestMapping(value={"/getLongLink"})
    public String getLongLink(HttpServletRequest request, HttpServletResponse response, String shortKey, String referer) {
        shortKey = shortKey.replace("/", "");
        return this.shortLinkService.getMallUrl(shortKey);
    }

    @RequestMapping(value={"/testId"})
    public DistributionInviteLogEntity testId() throws AuthorizeException, IOException {
        DistributionInviteLogEntity logEntity = new DistributionInviteLogEntity();
        logEntity.setInviteId("1");
        logEntity.setDistributorId(Integer.valueOf(1));
        logEntity.setDistributorRelationId(Integer.valueOf(1));
        logEntity.setDistributorRelationUserId("1");
        logEntity.setInvitedCustomerId("1");
        logEntity.setInviteSource("111");
        logEntity.setInviteTime(new Date());
        logEntity.setInviteType(Integer.valueOf(1));
        logEntity.setStatus(Integer.valueOf(1));
        logEntity.setUneffectLogId(null);
        return logEntity;
    }

    @RequestMapping(value={"/testBaId"})
    public BaseJsonVo testBaId() throws AuthorizeException, IOException {
        InteractionDetailEntity interactionDetailEntity = new InteractionDetailEntity();
        interactionDetailEntity.setCreateTime(DateUtils.now());
        interactionDetailEntity.setCustomerId("10003256340646139187456");
        interactionDetailEntity.setInteractionKey("haaaa");
        interactionDetailEntity.setType(Integer.valueOf(1));
        interactionDetailEntity.setPlatformId(Integer.valueOf(1));
        this.logger.info(interactionDetailEntity.toString());
        this.interactionDetailInterface.insertSelective((Object)interactionDetailEntity);
        return BaseJsonVo.success((Object)"");
    }

    @RequestMapping(value={"/getActiveRecord"})
    public BaseJsonVo getActiveRecord(String bindCode, String mobile) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        if (customerDetailVo != null && StringUtils.isNotEmpty((String)mobile)) {
            this.customerInterface.updateMobileByLogiscMessage(mobile, customerDetailVo.getCustomerId(), bindCode);
        }
        BaseJsonVo baseJsonVo = this.activeInterface.getActivePageVo(bindCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        ActiveGiftPropertyInfoVo activeGiftPropertyInfoVo = this.distributorGrowthActiveInterface.getActiveGiftPropertyInfoVo(bindCode);
        ActivePageVo activePageVo = (ActivePageVo)baseJsonVo.getValue();
        if (activeGiftPropertyInfoVo != null && StringUtils.isNotEmpty((String)activeGiftPropertyInfoVo.getArticleUrl())) {
            activePageVo.setActiveUrl(activeGiftPropertyInfoVo.getArticleUrl());
        }
        map.put("active", activePageVo);
        map.put("piclist", this.picInterface.getProductPicUrlMap(((ActivePageVo)baseJsonVo.getValue()).getActiveNo(), Integer.valueOf(SalesTypeEnum.SALES_ACTIVE.getValue())));
        map.put("picUrllist", this.activePropertyInterface.getPicPropertyList(((ActivePageVo)baseJsonVo.getValue()).getBindCode(), ((ActivePageVo)baseJsonVo.getValue()).getActiveNo()));
        if ("ece280645bb34ba0afbd3d5e64e6c275".equals(bindCode) && map != null && map.containsKey("active") && map.get("active") != null) {
            ((ActivePageVo)map.get("active")).setActiveUrl("https://mp.weixin.qq.com/s?__biz=MzA3MzU5MDgzMw==&mid=507939038&idx=1&sn=2ea4e35ddec62535b343962cead7956e&chksm=04be998033c910965691ba96c34895edfd830c1e8e1c679536da7b45ce79fe437d91cfa1d92f#rd");
        }
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/getActiveInfo"})
    public BaseJsonVo getActiveInfo(String bindCode) throws AuthorizeException {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u53c2\u6570");
        }
        if (!activeEntity.getActiveName().contains(":")) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u53c2\u6570");
        }
        String[] arr = activeEntity.getActiveName().split(":");
        map.put("name", arr[0]);
        map.put("token", arr[1]);
        map.put("list", this.picInterface.getProductPicUrlMap(activeEntity.getActiveNo(), Integer.valueOf(SalesTypeEnum.SALES_ACTIVE.getValue())));
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/getActivePicList"})
    public BaseJsonVo getActivePicList(String bindCode) throws AuthorizeException {
        BaseJsonVo baseJsonVo = new BaseJsonVo();
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        int userInfoStatus = StringUtils.isEmpty((String)customerDetailVo.getMobile()) ? 2 : 0;
        baseJsonVo.setUserInfoStatus(userInfoStatus);
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        HashMap<String, Map> map = new HashMap<String, Map>();
        if (activeEntity == null) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u7684\u6d3b\u52a8");
        }
        Map pic = this.picInterface.getProductPicUrlMap(activeEntity.getActiveNo(), Integer.valueOf(SalesTypeEnum.SALES_ACTIVE.getValue()));
        if ((CollectionUtils.isEmpty((Collection)((Collection)pic.get("picActiveHead"))) || Objects.equals(((List)pic.get("picActiveHead")).get(0), "")) && activeEntity.getActiveType() == 15) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("1000/toutu/get-coupon-bg1.jpg");
            list.add("1000/toutu/get-coupon-bg2.jpg");
            list.add("1000/toutu/get-coupon-bg3.jpg");
            list.add("1000/toutu/get-coupon-bg4.jpg");
            ArrayList<String> temp = new ArrayList<String>();
            for (String item : list) {
                temp.add(this.ossService.getImageResoure(item));
            }
            pic.put("picActiveHead", temp);
        }
        map.put("piclist", pic);
        return BaseJsonVo.success(map);
    }

    @RequestMapping(value={"/getPicLinkList"})
    public BaseJsonVo getPicLinkList(HttpServletRequest request, String bindCode, String referer) {
        String pageUrl = referer;
        if (StringUtils.isEmpty((String)pageUrl)) {
            pageUrl = request.getHeader("referer");
        }
        this.logger.info("pageUrl:{}", (Object)pageUrl);
        pageUrl = pageUrl.split("\\?")[0];
        this.logger.info("pageUrl:{}", (Object)pageUrl);
        return this.activeInterface.getPicLinkList(pageUrl, bindCode);
    }
}

