/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.distributorGift;

import cc.lechun.common.enums.customer.MobileValidateTypeEnum;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.controller.customer.CustomerController;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.distribution.ActiveGiftInviteInfoVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.customer.CustomerMobileInterface;
import cc.lechun.mall.iservice.distribution.DistributorGrowthActiveInterface;
import cc.lechun.mall.service.distribution.inviteGift.InviteGiftContext;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"gift"})
public class DistributorGiftController {
    private static final Logger log = LoggerFactory.getLogger(DistributorGiftController.class);
    @Autowired
    DistributorGrowthActiveInterface distributorGrowthActiveInterface;
    @Autowired
    CustomerLoginService customerLoginService;
    @Autowired
    private CustomerMobileInterface customerMobileInterface;
    @Autowired
    private CustomerController customerController;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    InviteGiftContext inviteGiftContext;

    @RequestMapping(value={"saveMobile"})
    public BaseJsonVo saveMobile(String bindCode, String mobile, String validateCode) throws AuthorizeException, IOException {
        int platformId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        log.info("\u9a8c\u8bc1\u7801:{}", (Object)validateCode);
        if (!this.customerMobileInterface.validateCode(MobileValidateTypeEnum.addressMobile.name(), mobile, validateCode)) {
            return BaseJsonVo.paramError((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.customerInterface.bindMobile(mobile, customerDetailVo.getCustomerId(), "");
        if (!baseJsonVo.isSuccess()) {
            return baseJsonVo;
        }
        return this.distributorGrowthActiveInterface.updateInviteWithoutOrder("", bindCode, customer.getCustomerId(), mobile, Integer.valueOf(platformId));
    }

    @RequestMapping(value={"authorMobile"})
    public BaseJsonVo authorMobile(HttpServletRequest request, HttpServletResponse response, String bindCode) throws AuthorizeException, IOException {
        BaseJsonVo baseJsonVo;
        int platformId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        CustomerEntity customerNew = new CustomerEntity();
        String iv = request.getParameter("iv");
        if (StringUtils.isNotEmpty((String)iv)) {
            baseJsonVo = this.customerController.bindMobileByMini(request, response);
            if (!baseJsonVo.isSuccess()) {
                return baseJsonVo;
            }
            customerNew = (CustomerEntity)baseJsonVo.getValue();
            customer.setMobile(customerNew.getMobile());
        }
        if (StringUtils.isEmpty((String)customer.getMobile())) {
            return BaseJsonVo.error((String)"\u8bf7\u5148\u6388\u6743\u624b\u673a\u53f7!");
        }
        baseJsonVo = this.inviteGiftContext.updateInviteWithoutOrder("", bindCode, customer.getCustomerId(), customer.getMobile(), Integer.valueOf(platformId));
        return BaseJsonVo.success((Object)customer.getMobile());
    }

    @RequestMapping(value={"testsaveMobile"})
    public BaseJsonVo testsaveMobile(String bindCode, String mobile, String validateCode) throws AuthorizeException, IOException {
        return this.distributorGrowthActiveInterface.updateInviteWithoutOrder("", bindCode, "10003251633019271048434", "18518673993", Integer.valueOf(1));
    }

    @RequestMapping(value={"getRechangCode"})
    public BaseJsonVo getRechangCode(String bindCode) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.inviteGiftContext.getRechangCode(bindCode, customer.getCustomerId());
    }

    @RequestMapping(value={"testgetRechangCode"})
    public BaseJsonVo testgetRechangCode(String bindCode) throws AuthorizeException {
        return this.inviteGiftContext.getRechangCode(bindCode, "10003355426914989387638");
    }

    @RequestMapping(value={"setRechange"})
    public BaseJsonVo setRechange(String bindCode, String rechangeCode) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.inviteGiftContext.setRechange(bindCode, rechangeCode, customer.getMobile(), customer.getCustomerId());
    }

    @RequestMapping(value={"testsetRechange"})
    public BaseJsonVo testsetRechange(String bindCode, String rechangeCode) throws AuthorizeException {
        return this.inviteGiftContext.setRechange(bindCode, rechangeCode, "18087263808", "10003355426914989387638");
    }

    @RequestMapping(value={"getActiveGiftInviteInfoVo"})
    public BaseJsonVo getActiveGiftInviteInfoVo(String bindCode) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        BaseJsonVo baseJsonVo = this.inviteGiftContext.getActiveGiftInviteInfoVo(bindCode, customer.getCustomerId(), Integer.valueOf(platformId));
        if (baseJsonVo.isSuccess()) {
            ((ActiveGiftInviteInfoVo)baseJsonVo.getValue()).setMobile(StringUtils.isNotEmpty((String)customer.getMobile()) ? customer.getMobile() : "");
        }
        return baseJsonVo;
    }

    @RequestMapping(value={"testgetActiveGiftInviteInfoVo"})
    public BaseJsonVo testgetActiveGiftInviteInfoVo(String bindCode) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        return this.inviteGiftContext.getActiveGiftInviteInfoVo(bindCode, "10003402931799821447905", Integer.valueOf(platformId));
    }

    @RequestMapping(value={"getActiveGiftTakedInfoVo"})
    public BaseJsonVo getActiveGiftTakedInfoVo(String source, String bindCode) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.inviteGiftContext.getActiveGiftTakedInfoVo(source, bindCode, customer.getCustomerId());
    }

    @RequestMapping(value={"testgetActiveGiftTakedInfoVo"})
    public BaseJsonVo testgetActiveGiftTakedInfoVo(String source, String bindCode, String customerId) throws AuthorizeException {
        return this.inviteGiftContext.getActiveGiftTakedInfoVo(source, bindCode, customerId);
    }

    @RequestMapping(value={"takedGift"})
    public BaseJsonVo takedGift(String source, String bindCode) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.inviteGiftContext.takedGift(source, bindCode, customer.getCustomerId());
    }

    @RequestMapping(value={"testtakedGift"})
    public BaseJsonVo testtakedGift(String source, String bindCode, String customerId) throws AuthorizeException {
        int platformId = this.customerLoginService.getPlatFormId();
        return this.inviteGiftContext.takedGift(source, bindCode, customerId);
    }

    @RequestMapping(value={"testUpdateInvite"})
    public BaseJsonVo testUpdateInvite(String bindCode, String orderNo, String customerId) throws AuthorizeException {
        return this.distributorGrowthActiveInterface.updateInvite(bindCode, customerId, orderNo);
    }

    @RequestMapping(value={"testSetInviteOrder"})
    public BaseJsonVo testSetInviteOrder(String bindCode, String orderNo, String customerId, String source) throws AuthorizeException {
        return this.distributorGrowthActiveInterface.setInviteOrder(source, bindCode, customerId, orderNo, Integer.valueOf(1));
    }
}

