/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.luckydraw;

import cc.lechun.active.iservice.luckydraw.ActiveLuckyDrawUserInterface;
import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"luckydraw"})
public class ActiveLuckyDrawController {
    @Autowired
    ActiveLuckyDrawUserInterface luckyDrawUserInterface;
    @Autowired
    CustomerLoginService customerLoginService;

    @RequestMapping(value={"getCurrentLucky"})
    public BaseJsonVo getCurrentLucky(String bindCode) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.luckyDrawUserInterface.getCurrentLucky(bindCode, customer.getCustomerId());
    }

    @RequestMapping(value={"reserveLucky"})
    public BaseJsonVo reserveLucky(String bindCode, Integer subscribe) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.luckyDrawUserInterface.reserveLucky(bindCode, customer.getCustomerId(), subscribe);
    }

    @RequestMapping(value={"getLuckyPrize"})
    public BaseJsonVo getLuckyPrize(String bindCode, String luckyDrawId) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        return this.luckyDrawUserInterface.getLuckyPrize(luckyDrawId, customer.getCustomerId());
    }

    @RequestMapping(value={"takeLuckyPrize"})
    public BaseJsonVo takeLuckyPrize(HttpServletRequest servletRequest, String bindCode, String luckyDrawId, Integer subscribe) throws AuthorizeException {
        CustomerDetailVo customer = this.customerLoginService.getCustomer(true);
        BaseJsonVo jsonVo = this.luckyDrawUserInterface.takeLuckyPrize(servletRequest, luckyDrawId, customer);
        BaseJsonVo j = this.luckyDrawUserInterface.reserveLucky(bindCode, customer.getCustomerId(), subscribe);
        String message = "";
        message = j.isSuccess() ? "\u9884\u7ea6\u6210\u529f" : j.getMessage();
        if (jsonVo.isSuccess()) {
            jsonVo.setValue((Object)(jsonVo.getValue().toString() + "," + message));
        }
        return jsonVo;
    }
}

