/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.active.controller.promotion;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/promotion"})
public class PromotionController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallPromotionInterface promotionService;
    @Autowired
    private CustomerLoginService customerLoginService;

    @RequestMapping(value={"/getPromotionByBindCode"})
    public BaseJsonVo getPromotionByBindCode(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        return this.promotionService.getPromotionByBindCode(customerDetailVo.getCustomerId(), bindCode);
    }

    @RequestMapping(value={"/getPromotion"})
    public BaseJsonVo getPromotion(String bindCode) {
        return this.promotionService.getPromotionByBindCode(bindCode);
    }
}

