/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.api;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.weixin.WeiXinBaseInterface;
import cc.lechun.mallapi.api.MiniShopRefundApi;
import cc.lechun.mallapi.dto.miniShopRefund.MiniShopRefundDTO;
import cc.lechun.mallapi.dto.miniShopRefund.MiniShopRefundUpdateDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestBody;
import weixin.popular.api.shop.RefundAPI;
import weixin.popular.bean.BaseResult;

@Service
public class MiniShopRefundApiService
implements MiniShopRefundApi {
    private static final Logger logger = LoggerFactory.getLogger(MiniShopRefundApiService.class);
    @Autowired
    MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    CustomerInterface customerInterface;
    @Autowired
    WeiXinBaseInterface weiXinBaseInterface;
    @Autowired
    MallOrderGroupProductInterface mallOrderGroupProductInterface;

    public BaseJsonVo<String> createMiniShopRefund(@RequestBody MiniShopRefundDTO miniShopRefundDTO) {
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(miniShopRefundDTO.getOut_order_id());
        if (mallOrderMainEntity.getMiniShop() == 1) {
            CustomerDetailVo customerDetail = this.customerInterface.getCustomerDetail(mallOrderMainEntity.getCustomerId(), mallOrderMainEntity.getPlatformId().intValue());
            miniShopRefundDTO.setOpenid(customerDetail.getOpenId());
            miniShopRefundDTO.getProduct_infos().forEach(product -> {
                product.setOut_product_id(this.mallOrderGroupProductInterface.getOrderGroupProductByID(product.getOut_product_id()).getProductId());
                product.setOut_sku_id(product.getOut_product_id());
            });
            String accessToken = this.weiXinBaseInterface.getAccessTokenByPlatformId(mallOrderMainEntity.getPlatformId()).getAccessToken();
            BaseResult baseResult = RefundAPI.refundSync((String)accessToken, (String)JsonUtils.toJson((Object)miniShopRefundDTO, (boolean)false));
            logger.info("******createMiniShopRefund*****param:{},result:{}", (Object)JsonUtils.toJson((Object)miniShopRefundDTO, (boolean)false), (Object)JsonUtils.toJson((Object)baseResult, (boolean)false));
            if (baseResult.isSuccess()) {
                return BaseJsonVo.success(null);
            }
            return BaseJsonVo.error((String)baseResult.getErrmsg());
        }
        return BaseJsonVo.success((String)"{}\u975e\u5c0f\u5546\u5e97\u8ba2\u5355\uff0c\u4e0d\u7528\u540c\u6b65", (Object)miniShopRefundDTO.getOut_order_id());
    }

    public BaseJsonVo<String> updateMiniShopRefund(@RequestBody MiniShopRefundUpdateDTO miniShopRefundUpdateDTO) {
        MallOrderMainEntity mallOrderMainEntity = this.mallOrderMainInterface.selectByPrimaryKey(miniShopRefundUpdateDTO.getOut_order_id());
        if (mallOrderMainEntity.getMiniShop() == 1) {
            CustomerDetailVo customerDetail = this.customerInterface.getCustomerDetail(mallOrderMainEntity.getCustomerId(), mallOrderMainEntity.getPlatformId().intValue());
            miniShopRefundUpdateDTO.setOpenid(customerDetail.getOpenId());
            String accessToken = this.weiXinBaseInterface.getAccessTokenByPlatformId(mallOrderMainEntity.getPlatformId()).getAccessToken();
            BaseResult baseResult = RefundAPI.refundStatusSync((String)accessToken, (String)JsonUtils.toJson((Object)miniShopRefundUpdateDTO, (boolean)false));
            logger.info("******updateMiniShopRefund*****param:{},result:{}", (Object)JsonUtils.toJson((Object)miniShopRefundUpdateDTO, (boolean)false), (Object)JsonUtils.toJson((Object)baseResult, (boolean)false));
            if (baseResult.isSuccess()) {
                return BaseJsonVo.success(null);
            }
            return BaseJsonVo.error((String)baseResult.getErrmsg());
        }
        return BaseJsonVo.success((String)"{}\u975e\u5c0f\u5546\u5e97\u8ba2\u5355\uff0c\u4e0d\u7528\u540c\u6b65", (Object)miniShopRefundUpdateDTO.getOut_order_id());
    }
}

