/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.api;

import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.prepay.PrepayCardBatchEntity;
import cc.lechun.mall.entity.prepay.PrepayCardDetailEntity;
import cc.lechun.mall.entity.sales.MallIndexProductVo;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.iservice.prepay.PrepayCardBatchInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardItemInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mall.iservice.shoppingcart.MallShoppingcartInterface;
import cc.lechun.mall.iservice.trade.orderPlan.MallOrderPlanDomainInterface;
import cc.lechun.mallapi.api.MallTempMsgApi;
import cc.lechun.mallapi.api.PrepayCardPlanApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayCardPlanApiService
implements PrepayCardPlanApi {
    private static final Logger log = LoggerFactory.getLogger(MallTempMsgApi.class);
    @Autowired
    PrepayCardPlanDetailInterface planDetailInterface;
    @Autowired
    PrepayCardInterface prepayCardInterface;
    @Autowired
    private PrepayCardOrderPlanInterface prepayCardOrderPlanService;
    @Autowired
    private MallOrderPlanDomainInterface orderPlanDomainInterface;
    @Autowired
    private PrepayCardItemInterface prepayCardItemInterface;
    @Autowired
    private PrepayCardBatchInterface prepayCardBatchInterface;
    @Autowired
    private BalanceAccountInvoke balanceAccountInvoke;
    @Autowired
    MallShoppingcartInterface cartService;

    public BaseJsonVo getCardPlanDetail(String cardId) {
        return this.prepayCardOrderPlanService.getCardPlanDetail(cardId);
    }

    public BaseJsonVo getPrepayCardItemList(Integer detailedId, String bindCode, String customerId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BaseJsonVo jsonVo = this.prepayCardItemInterface.getPrepayCardItem(customerId, bindCode);
        map.put("item", jsonVo.isSuccess() ? jsonVo.getValue() : new ArrayList());
        PrepayCardBatchEntity entity = new PrepayCardBatchEntity();
        entity.setBindCode(bindCode);
        entity = (PrepayCardBatchEntity)this.prepayCardBatchInterface.getSingle((Object)entity);
        if (entity != null) {
            BaseJsonVo productSR;
            map.put("limitMinCount", entity.getPerPrice().intValue());
            BaseJsonVo jsonVo1 = this.balanceAccountInvoke.getSpecialTotal(customerId, entity.getCardType());
            if (jsonVo1.isSuccess()) {
                BigDecimal unUsedPoint = (BigDecimal)jsonVo1.getValue();
                map.put("saleValue", unUsedPoint);
                List pointPlanList = this.prepayCardOrderPlanService.getPointPrepayCardDetailEntityList(customerId);
                if (CollectionUtils.isNotEmpty((Collection)pointPlanList)) {
                    Optional<PrepayCardDetailEntity> thisDetail;
                    if (detailedId != null && (thisDetail = pointPlanList.stream().filter(d -> Objects.equals(d.getDetailedId(), detailedId)).findFirst()).isPresent()) {
                        unUsedPoint = PriceUtils.add((BigDecimal)unUsedPoint, (BigDecimal)thisDetail.get().getPricePoint());
                    }
                    BigDecimal usedPoint = pointPlanList.stream().map(PrepayCardDetailEntity::getPricePoint).reduce(BigDecimal.ZERO, BigDecimal::add);
                    map.put("saleValue", PriceUtils.subtract((BigDecimal)unUsedPoint, (BigDecimal)usedPoint));
                }
            }
            if (!(productSR = this.cartService.buildShoppingcartProducts(customerId, Boolean.valueOf(true), bindCode)).isSuccess()) {
                return productSR;
            }
            for (MallIndexProductVo indexProductVo : (List)jsonVo.getValue()) {
                for (MallProductVO productVO : (List)productSR.getValue()) {
                    if (!Objects.equals(indexProductVo.getProductId(), productVO.getProId())) continue;
                    indexProductVo.setQuantity(productVO.getCount());
                }
            }
        }
        return BaseJsonVo.success(map);
    }

    public BaseJsonVo savePointCardOrderPlan(int detailedId) {
        return this.orderPlanDomainInterface.saveOrderPlan(detailedId);
    }

    public BaseJsonVo getCardList(String customerId) {
        return this.prepayCardOrderPlanService.getCardList(customerId);
    }

    public BaseJsonVo pushFinshMessage() {
        return this.prepayCardInterface.pushFinshMessage();
    }

    public BaseJsonVo pushExpiredMessage() {
        return this.prepayCardInterface.pushExpiredMessage();
    }

    public BaseJsonVo pushProcessMessage() {
        return this.prepayCardInterface.pushProcessMessage();
    }

    public BaseJsonVo pushActivedMessage() {
        return this.prepayCardInterface.pushActivedMessage();
    }

    public BaseJsonVo createPlanOrder(Date today) {
        BaseJsonVo baseJsonVo = BaseJsonVo.success((Object)"");
        try {
            if (today == null) {
                today = DateUtils.currentDate();
            }
            baseJsonVo = this.planDetailInterface.createPlanOrder(today);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baseJsonVo;
    }

    public BaseJsonVo orderRefundUpdateCardPlanStatus(String orderMainNo) {
        return this.planDetailInterface.orderRefundUpdateCardPlanStatus(orderMainNo);
    }

    public BaseJsonVo orderAllRefundUpdateCardPlanStatus(String orderMainNo) {
        return this.prepayCardInterface.orderAllRefundUpdateCardPlanStatus(orderMainNo);
    }

    public BaseJsonVo orderConfirmGoodsUpdateCardPlanStatus(String orderMainNo) {
        return this.planDetailInterface.orderConfirmGoodsUpdateCardPlanStatus(orderMainNo);
    }
}

