/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.api;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.prepay.PrepayCardDetailProductItemVo;
import cc.lechun.mall.iservice.prepay.PrepayCardInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardOrderPlanInterface;
import cc.lechun.mall.iservice.prepay.PrepayCardPlanDetailInterface;
import cc.lechun.mallapi.api.RefundPrepayCardPlanApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RefundPrepayCardPlanApiService
implements RefundPrepayCardPlanApi {
    private static final Logger log = LoggerFactory.getLogger(RefundPrepayCardPlanApiService.class);
    @Autowired
    PrepayCardPlanDetailInterface planDetailInterface;
    @Autowired
    PrepayCardInterface prepayCardInterface;
    @Autowired
    private PrepayCardOrderPlanInterface prepayCardOrderPlanService;

    public BaseJsonVo getCardInfo(String orderMainNo) {
        return this.prepayCardOrderPlanService.getCardInfo(orderMainNo);
    }

    public BaseJsonVo getOrderPlanDetail(Integer planId) {
        return this.prepayCardOrderPlanService.getOrderPlanDetail(planId);
    }

    public BaseJsonVo refundOrderPlan(String orderMainNo, BigDecimal amount, String productList, String operator) {
        log.info("\u9000\u6b3e\u53c2\u6570 orderMainNo={},amount={},productList={},operator={}", new Object[]{orderMainNo, amount, productList, operator});
        List list = new ArrayList();
        if (StringUtils.isNotEmpty((String)productList)) {
            list = JsonUtils.getListByArray(PrepayCardDetailProductItemVo.class, (String)productList);
        }
        return this.prepayCardOrderPlanService.refundOrderPlan(orderMainNo, amount, list, operator);
    }

    public BaseJsonVo refundOrderPlanNum(String orderMainNo, String operator) {
        log.info("\u9000\u6b3e\u53c2\u6570 orderMainNo={},operator={}", (Object)orderMainNo, (Object)operator);
        return this.prepayCardOrderPlanService.refundOrderPlanNum(orderMainNo, operator);
    }
}

