/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.api;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.weixin.MessageInterface;
import cc.lechun.mallapi.api.WechatTempMsgApi;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatTempMessageApiService
implements WechatTempMsgApi {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerInterface customerService;
    @Autowired
    private MessageInterface messageService;

    public BaseJsonVo sendTempMsg(int messageType, Integer messageId, String customerId, Integer platformId, Map<String, String> variableMap) {
        this.logger.info("\u7528\u6237:{},\u5e73\u53f0:{},\u6a21\u677fID:{}", new Object[]{customerId, platformId, messageId});
        if (variableMap != null && !variableMap.containsKey("nickName")) {
            CustomerDetailVo customerDetailVo = this.customerService.getCustomerDetail(customerId, platformId.intValue());
            variableMap.put("nickName", customerDetailVo != null ? customerDetailVo.getNickName() : "\u4e50\u7eaf\u7684\u4f19\u4f34\u4eec");
        }
        return this.messageService.sendWechatMessage(messageType, messageId, customerId, variableMap);
    }

    public BaseJsonVo sendWechatMessage(String actionId, String customerId, Map<String, String> variableMap) {
        this.logger.info("\u52a8\u4f5c:{},customerId:{},\u53d8\u91cf:{}", new Object[]{actionId, customerId, JsonUtils.toJson(variableMap, (boolean)false)});
        return this.messageService.sendWechatMessage(actionId, customerId, variableMap);
    }
}

