/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.ask;

import cc.lechun.common.login.CustomerLoginService;
import cc.lechun.framework.common.utils.exception.AuthorizeException;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.ask.QuestionnaireVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.iservice.ask.MallAskInterface;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mallAsk"})
public class MallAskController {
    private static final Logger log = LoggerFactory.getLogger(MallAskController.class);
    @Autowired
    private CustomerLoginService customerLoginService;
    @Autowired
    private MallAskInterface mallAskInterface;

    @ResponseBody
    @RequestMapping(value={"/getNextQuestion"})
    public BaseJsonVo getNextQuestion(HttpServletRequest request, HttpServletResponse response, String bindCode) {
        BaseJsonVo baseJsonVo = null;
        try {
            CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
            if (customerDetailVo != null) {
                baseJsonVo = this.mallAskInterface.getNextQuestion(customerDetailVo.getCustomerId(), bindCode);
            }
        }
        catch (AuthorizeException e) {
            e.printStackTrace();
            log.error("+++++cc.lechun.mall.controller.ask.MallAskController.getNextQuestion++++Exception={}", (Object)e.getMessage());
        }
        return baseJsonVo;
    }

    @ResponseBody
    @RequestMapping(value={"/getQuestionList"})
    public BaseJsonVo getQuestionList(String bindCode, String orderNo) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        try {
            return this.mallAskInterface.getQuestionList(customerDetailVo.getCustomerId(), bindCode, orderNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("+++++cc.lechun.mall.controller.ask.MallAskController.getNextQuestion++++Exception={}", (Object)e.getMessage());
            return BaseJsonVo.error((String)"");
        }
    }

    @ResponseBody
    @RequestMapping(value={"/close"})
    public BaseJsonVo close(String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        try {
            this.mallAskInterface.close(bindCode, customerDetailVo.getCustomerId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseJsonVo.success((Object)"");
    }

    @ResponseBody
    @RequestMapping(value={"/commitQuestionnaireAnswer"})
    public BaseJsonVo commitQuestionnaireAnswer(String orderNo, String items, String bindCode) throws AuthorizeException {
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        try {
            log.info("\u53c2\u6570orderNo:{},bindCode:{},item:{}", new Object[]{orderNo, bindCode, items});
            items = URLDecoder.decode(items, "utf-8");
            List list = JsonUtils.getListByArray(QuestionnaireVo.class, (String)items);
            log.info(JsonUtils.toJson((Object)list, (boolean)false));
            BaseJsonVo baseJsonVo = this.mallAskInterface.commitAnswer(list, bindCode, orderNo, customerDetailVo.getCustomerId(), customerDetailVo.getPlatformId(), customerDetailVo.getPlatformGroupId());
            this.mallAskInterface.saveAire(bindCode, orderNo, customerDetailVo.getCustomerId(), customerDetailVo.getPlatformId(), customerDetailVo.getNickName(), list);
            return baseJsonVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseJsonVo.error((String)"");
        }
    }

    @ResponseBody
    @RequestMapping(value={"/TestgetQuestionList"})
    public BaseJsonVo TestgetQuestionList(HttpServletRequest request, HttpServletResponse response, String bindCode, String orderNo) throws AuthorizeException {
        try {
            return this.mallAskInterface.getQuestionList("10003341782013717652996", bindCode, orderNo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("+++++cc.lechun.mall.controller.ask.MallAskController.getNextQuestion++++Exception={}", (Object)e.getMessage());
            return BaseJsonVo.error((String)"");
        }
    }

    @ResponseBody
    @RequestMapping(value={"/commitAnswer"})
    public BaseJsonVo commitAnswer(HttpServletRequest request, HttpServletResponse response, String bindCode, String questionId, String answerId, String feedBack) throws AuthorizeException {
        BaseJsonVo baseJsonVo = null;
        CustomerDetailVo customerDetailVo = this.customerLoginService.getCustomer(true);
        try {
            if (customerDetailVo != null) {
                baseJsonVo = this.mallAskInterface.commitAnswer(customerDetailVo, questionId, answerId, bindCode, feedBack);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baseJsonVo;
    }

    @ResponseBody
    @RequestMapping(value={"/TestcommitAnswer"})
    public BaseJsonVo TestcommitAnswer(String bindCode, String feedBack) throws AuthorizeException {
        BaseJsonVo baseJsonVo = null;
        String temp = "%5B%7B%22naireStatus%22%3A2%2C%22naireName%22%3A%22%E6%9C%AA%E7%AD%94%22%2C%22remark%22%3A%22%E4%B8%BA%E4%BA%86%E6%9B%B4%E5%A5%BD%E7%9A%84%E6%9C%8D%E5%8A%A1%E5%B0%8F%E4%BC%99%E4%BC%B4%EF%BC%8C%E9%82%80%E8%AF%B7%E5%B0%8F%E4%BC%99%E4%BC%B4%E8%8A%B11%E5%88%86%E9%92%9F%E6%97%B6%E9%97%B4%E5%B8%AE%E5%8A%A9%E5%AE%8C%E6%88%90%E4%BB%A5%E4%B8%8B%E9%97%AE%E5%8D%B7%EF%BC%8C%E6%8F%90%E4%BA%A4%E9%97%AE%E5%8D%B7%E5%90%8E%E5%B0%86%E9%80%81%E6%82%A8%E4%B8%80%E5%BC%A015%E5%85%83%E4%BC%98%E6%83%A0%E5%88%B8%22%2C%22orderNo%22%3A%22202007071429122499809280%22%2C%22questionnewVoList%22%3A%5B%7B%22questionId%22%3A%2270a69efd-4d60-11e6-a878-0021cc5d6bck%22%2C%22question%22%3A%22%E8%AF%B7%E9%97%AE%E6%82%A8%E4%B9%90%E6%84%8F%E7%BB%99%E6%9C%8B%E5%8F%8B%E6%8E%A8%E8%8D%90%E4%B9%90%E7%BA%AF%E5%90%97%EF%BC%9F%22%2C%22remark%22%3A%22%E8%AF%B7%E5%9C%A80-10%E8%AF%84%E5%88%86%EF%BC%8C0%E4%BB%A3%E8%A1%A8%E4%B8%8D%E4%BC%9A%E6%8E%A8%E8%8D%90%EF%BC%8C10%E5%88%86%E4%BB%A3%E8%A1%A8%E9%9D%9E%E5%B8%B8%E5%8E%9F%E5%9B%A0%22%2C%22sequence%22%3A1%2C%22status%22%3A1%2C%22statusName%22%3A%22%22%2C%22flagScore%22%3A6%2C%22answerItemList%22%3A%5B%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0022cc5d6bcc%22%2C%22answer%22%3A%220%22%2C%22check%22%3A1%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0023cc5d6bcc%22%2C%22answer%22%3A%221%22%2C%22check%22%3A1%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0024cc5d6bcc%22%2C%22answer%22%3A%222%22%2C%22check%22%3A1%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0025cc5d6bcc%22%2C%22answer%22%3A%223%22%2C%22check%22%3A1%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0026cc5d6bcc%22%2C%22answer%22%3A%224%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0027cc5d6bcc%22%2C%22answer%22%3A%225%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0028cc5d6bcc%22%2C%22answer%22%3A%226%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0029cc5d6bcc%22%2C%22answer%22%3A%227%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0030cc5d6bcc%22%2C%22answer%22%3A%228%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0031cc5d6bcc%22%2C%22answer%22%3A%229%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0032cc5d6bcc%22%2C%22answer%22%3A%2210%22%2C%22check%22%3A0%7D%5D%2C%22children%22%3A%5B%7B%22questionId%22%3A%2270a69efd-4d60-11e6-a878-0021cc5d6bcl%22%2C%22question%22%3A%22%E4%B9%90%E7%BA%AF%E9%9D%9E%E5%B8%B8%E5%85%B3%E5%BF%83%E6%82%A8%E7%9A%84%E6%84%8F%E8%A7%81%EF%BC%8C%E8%AF%B7%E9%97%AE%E6%82%A8%E4%B8%8D%E6%84%BF%E6%84%8F%E6%8E%A8%E8%8D%90%E4%B9%90%E7%BA%AF%E7%9A%84%E5%8E%9F%E5%9B%A0%E6%98%AF%3F(%E5%A4%9A%E9%80%89)%22%2C%22remark%22%3A%22%22%2C%22sequence%22%3A2%2C%22status%22%3A1%2C%22statusName%22%3A%22%E5%B0%8F%E4%BA%8E%E7%AD%89%E4%BA%8E6%E5%88%86%22%2C%22flagScore%22%3A0%2C%22answerItemList%22%3A%5B%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2239ab4a8d-4d64-11e6-a878-0021cc5d7bca%22%2C%22answer%22%3A%22%E5%AE%9A%E4%BB%B7%E5%A4%AA%E9%AB%98%EF%BC%8C%E4%BC%98%E6%83%A0%E6%B4%BB%E5%8A%A8%E5%A4%AA%E5%B0%91%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0034cc5d6bcc%22%2C%22answer%22%3A%22%E5%8F%A3%E5%91%B3%E4%B8%80%E8%88%AC%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0035cc5d6bcc%22%2C%22answer%22%3A%22%E5%8F%A3%E5%91%B3%E8%BE%83%E5%B0%91%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0036cc5d6bcc%22%2C%22answer%22%3A%22%E4%BA%A7%E5%93%81%E6%A6%82%E5%BF%B5%E4%B8%8D%E5%90%B8%E5%BC%95%E4%BA%BA%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0037cc5d6bcc%22%2C%22answer%22%3A%22%E5%8C%85%E8%A3%85%E4%B8%8D%E5%A4%9F%E5%90%B8%E5%BC%95%E4%BA%BA%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0038cc5d6bcc%22%2C%22answer%22%3A%22%E4%BA%A7%E5%93%81%E7%BC%BA%E4%B9%8F%E5%88%9B%E6%96%B0%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0039cc5d6bcc%22%2C%22answer%22%3A%22%E6%B4%BB%E5%8A%A8%E5%A4%AA%E6%97%A0%E8%B6%A3%E3%80%81%E5%A4%AA%E5%B0%91%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0040cc5d6bcc%22%2C%22answer%22%3A%22%E8%B4%AD%E4%B9%B0%E6%B5%81%E7%A8%8B%E7%B9%81%E7%90%90%EF%BC%8C%E6%93%8D%E4%BD%9C%E5%A4%8D%E6%9D%82%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0041cc5d6bcc%22%2C%22answer%22%3A%22%E9%97%AE%E9%A2%98%E8%A7%A3%E5%86%B3%E6%97%B6%E9%97%B4%E9%95%BF%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0042cc5d6bcc%22%2C%22answer%22%3A%22%E6%9C%8D%E5%8A%A1%E8%B4%A8%E9%87%8F%E4%B8%8D%E5%A4%AA%E5%A5%BD%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0043cc5d6bcc%22%2C%22answer%22%3A%22%E6%9C%8D%E5%8A%A1%E6%80%81%E5%BA%A6%E4%B8%8D%E5%A5%BD%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0044cc5d6bcc%22%2C%22answer%22%3A%22%E9%85%8D%E9%80%81%E6%9C%8D%E5%8A%A1%E4%B8%8D%E5%A5%BD%22%2C%22check%22%3A1%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0045cc5d6bcc%22%2C%22answer%22%3A%22%E9%85%8D%E9%80%81%E5%9F%8E%E5%B8%82%E5%A4%AA%E5%B0%91%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22popiopp%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0060cc5d6bcc%22%2C%22answer%22%3A%22%E5%85%B6%E4%BB%96%22%2C%22check%22%3A0%7D%5D%7D%2C%7B%22questionId%22%3A%2270a69efd-4d60-11e6-a878-0021cc5d6bcm%22%2C%22question%22%3A%22%E5%A6%82%E6%9E%9C%E4%B9%90%E7%BA%AF%E5%81%9A%E5%88%B0%E4%BB%A5%E4%B8%8B%E5%93%AA%E4%BA%9B%E7%82%B9%EF%BC%8C%E6%82%A8%E4%BC%9A%E6%9B%B4%E6%84%BF%E6%84%8F%E5%90%91%E5%88%AB%E4%BA%BA%E6%8E%A8%E8%8D%90%E4%B9%90%E7%BA%AF%3F(%E5%A4%9A%E9%80%89)%22%2C%22remark%22%3A%22%22%2C%22sequence%22%3A2%2C%22status%22%3A2%2C%22statusName%22%3A%22%E5%A4%A7%E4%BA%8E6%E5%88%86%22%2C%22flagScore%22%3A0%2C%22answerItemList%22%3A%5B%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0046cc5d6bcc%22%2C%22answer%22%3A%22%E5%AE%9A%E4%BB%B7%E6%9B%B4%E5%90%88%E7%90%86%E4%B8%80%E7%82%B9%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0047cc5d6bcc%22%2C%22answer%22%3A%22%E4%BC%98%E6%83%A0%E6%B4%BB%E5%8A%A8%E6%9B%B4%E5%A4%9A%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0048cc5d6bcc%22%2C%22answer%22%3A%22%E6%8F%90%E5%8D%87%E4%BA%A7%E5%93%81%E6%80%A7%E4%BB%B7%E6%AF%94%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0049cc5d6bcc%22%2C%22answer%22%3A%22%E9%85%8D%E9%80%81%E6%9C%8D%E5%8A%A1%E6%9B%B4%E5%8A%A0%E5%AE%8C%E5%96%84%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0050cc5d6bcc%22%2C%22answer%22%3A%22%E4%BA%A7%E5%93%81%E6%8F%90%E4%BE%9B%E6%9B%B4%E4%B8%B0%E5%AF%8C%E7%9A%84%E5%8F%A3%E5%91%B3%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0051cc5d6bcc%22%2C%22answer%22%3A%22%E4%BA%A7%E5%93%81%E5%8F%A3%E6%84%9F%E6%9B%B4%E5%AE%8C%E5%96%84%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0052cc5d6bcc%22%2C%22answer%22%3A%22%E5%8C%85%E8%A3%85%E5%81%9A%E7%9A%84%E6%9B%B4%E7%B2%BE%E7%BE%8E%EF%BC%8C%E6%9B%B4%E5%90%B8%E5%BC%95%E4%BA%BA%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0053cc5d6bcc%22%2C%22answer%22%3A%22%E6%9B%B4%E5%A4%9A%E5%88%9B%E6%96%B0%E6%96%B0%E5%93%81%E5%93%81%E7%B1%BB%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0054cc5d6bcc%22%2C%22answer%22%3A%22%E5%A4%9A%E5%81%9A%E6%9C%89%E8%B6%A3%E6%9C%89%E6%84%8F%E4%B9%89%E7%9A%84%E6%B4%BB%E5%8A%A8%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0055cc5d6bcc%22%2C%22answer%22%3A%22%E4%BC%98%E5%8C%96%E7%BD%91%E4%B8%8A%E8%B4%AD%E4%B9%B0%E4%B9%90%E7%BA%AF%E7%9A%84%E6%93%8D%E4%BD%9C%E6%B5%81%E7%A8%8B%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0056cc5d6bcc%22%2C%22answer%22%3A%22%E6%8A%95%E8%AF%89%E5%A4%84%E7%90%86%E6%95%88%E7%8E%87%E6%8F%90%E9%AB%98%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0057cc5d6bcc%22%2C%22answer%22%3A%22%E6%8F%90%E5%8D%87%E5%AE%A2%E6%9C%8D%E5%AF%B9%E6%8E%A5%E6%80%81%E5%BA%A6%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0058cc5d6bcc%22%2C%22answer%22%3A%22%E5%A4%9A%E5%81%9A%E5%93%81%E7%89%8C%E6%95%99%E8%82%B2%E5%AE%A3%E4%BC%A0%EF%BC%8C%E8%AE%A9%E4%BA%BA%E6%9B%B4%E4%BA%86%E8%A7%A3%E8%BF%99%E4%B8%AA%E5%93%81%E7%89%8C%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0059cc5d6bcc%22%2C%22answer%22%3A%22%E5%85%B6%E4%BB%96%22%2C%22check%22%3A0%7D%5D%7D%5D%2C%22selectScore%22%3A0%7D%5D%7D%5D";
        try {
            temp = URLDecoder.decode(temp, "utf-8");
            List list = JsonUtils.getListByArray(QuestionnaireVo.class, (String)temp);
            baseJsonVo = this.mallAskInterface.commitAnswer(list, bindCode, "", "10003341782013717652996", Integer.valueOf(1), Integer.valueOf(1000));
            this.mallAskInterface.saveAire(bindCode, "202007141532573196063744", "10003341782013717652996", Integer.valueOf(1), "\u6d6a\u82b1", list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baseJsonVo;
    }

    @ResponseBody
    @RequestMapping(value={"/TestcommitsaveAire"})
    public BaseJsonVo TestcommitsaveAire(String bindCode, String orderNo, String feedBack) throws AuthorizeException {
        BaseJsonVo baseJsonVo = null;
        try {
            BigDecimal score = new BigDecimal(6);
            String temp = "%5B%7B%22remark%22%3A%22%E4%B8%BA%E4%BA%86%E6%9B%B4%E5%A5%BD%E7%9A%84%E6%9C%8D%E5%8A%A1%E5%B0%8F%E4%BC%99%E4%BC%B4%EF%BC%8C%E9%82%80%E8%AF%B7%E5%B0%8F%E4%BC%99%E4%BC%B4%E8%8A%B11%E5%88%86%E9%92%9F%E6%97%B6%E9%97%B4%E5%B8%AE%E5%8A%A9%E5%AE%8C%E6%88%90%E4%BB%A5%E4%B8%8B%E9%97%AE%E5%8D%B7%EF%BC%8C%E6%8F%90%E4%BA%A4%E9%97%AE%E5%8D%B7%E5%90%8E%E5%B0%86%E9%80%81%E6%82%A8%E4%B8%80%E5%BC%A015%E5%85%83%E4%BC%98%E6%83%A0%E5%88%B8%22%2C%22questionnewVoList%22%3A%5B%7B%22questionId%22%3A%2270a69efd-4d60-11e6-a878-0021cc5d6bck%22%2C%22question%22%3A%22%E8%AF%B7%E9%97%AE%E6%82%A8%E4%B9%90%E6%84%8F%E7%BB%99%E6%9C%8B%E5%8F%8B%E6%8E%A8%E8%8D%90%E4%B9%90%E7%BA%AF%E5%90%97%EF%BC%9F%22%2C%22remark%22%3A%22%E8%AF%B7%E5%9C%A80-10%E8%AF%84%E5%88%86%EF%BC%8C0%E4%BB%A3%E8%A1%A8%E4%B8%8D%E4%BC%9A%E6%8E%A8%E8%8D%90%EF%BC%8C10%E5%88%86%E4%BB%A3%E8%A1%A8%E9%9D%9E%E5%B8%B8%E5%8E%9F%E5%9B%A0%22%2C%22sequence%22%3A1%2C%22status%22%3A1%2C%22statusName%22%3A%22%22%2C%22flagScore%22%3A6.00%2C%22answerItemList%22%3A%5B%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0022cc5d6bcc%22%2C%22answer%22%3A%220%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0023cc5d6bcc%22%2C%22answer%22%3A%221%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0024cc5d6bcc%22%2C%22answer%22%3A%222%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0025cc5d6bcc%22%2C%22answer%22%3A%223%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0026cc5d6bcc%22%2C%22answer%22%3A%224%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0027cc5d6bcc%22%2C%22answer%22%3A%225%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0028cc5d6bcc%22%2C%22answer%22%3A%226%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0029cc5d6bcc%22%2C%22answer%22%3A%227%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0030cc5d6bcc%22%2C%22answer%22%3A%228%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0031cc5d6bcc%22%2C%22answer%22%3A%229%22%2C%22check%22%3A1%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0032cc5d6bcc%22%2C%22answer%22%3A%2210%22%2C%22check%22%3A0%7D%5D%2C%22children%22%3A%5B%7B%22questionId%22%3A%2270a69efd-4d60-11e6-a878-0021cc5d6bcl%22%2C%22question%22%3A%22%E4%B9%90%E7%BA%AF%E9%9D%9E%E5%B8%B8%E5%85%B3%E5%BF%83%E6%82%A8%E7%9A%84%E6%84%8F%E8%A7%81%EF%BC%8C%E8%AF%B7%E9%97%AE%E6%82%A8%E4%B8%8D%E6%84%BF%E6%84%8F%E6%8E%A8%E8%8D%90%E4%B9%90%E7%BA%AF%E7%9A%84%E5%8E%9F%E5%9B%A0%E6%98%AF%3F(%E5%A4%9A%E9%80%89)%22%2C%22remark%22%3A%22%22%2C%22sequence%22%3A2%2C%22status%22%3A1%2C%22statusName%22%3A%22%E5%B0%8F%E4%BA%8E%E7%AD%89%E4%BA%8E6%E5%88%86%22%2C%22flagScore%22%3A0%2C%22answerItemList%22%3A%5B%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2239ab4a8d-4d64-11e6-a878-0021cc5d7bca%22%2C%22answer%22%3A%22%E5%AE%9A%E4%BB%B7%E5%A4%AA%E9%AB%98%EF%BC%8C%E4%BC%98%E6%83%A0%E6%B4%BB%E5%8A%A8%E5%A4%AA%E5%B0%91%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0034cc5d6bcc%22%2C%22answer%22%3A%22%E5%8F%A3%E5%91%B3%E4%B8%80%E8%88%AC%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0035cc5d6bcc%22%2C%22answer%22%3A%22%E5%8F%A3%E5%91%B3%E8%BE%83%E5%B0%91%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0036cc5d6bcc%22%2C%22answer%22%3A%22%E4%BA%A7%E5%93%81%E6%A6%82%E5%BF%B5%E4%B8%8D%E5%90%B8%E5%BC%95%E4%BA%BA%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0037cc5d6bcc%22%2C%22answer%22%3A%22%E4%BA%A7%E5%93%81%E7%BC%BA%E4%B9%8F%E5%88%9B%E6%96%B0%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0038cc5d6bcc%22%2C%22answer%22%3A%22%E6%B4%BB%E5%8A%A8%E5%A4%AA%E6%97%A0%E8%B6%A3%E3%80%81%E5%A4%AA%E5%B0%91%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0039cc5d6bcc%22%2C%22answer%22%3A%22%E8%B4%AD%E4%B9%B0%E6%B5%81%E7%A8%8B%E7%B9%81%E7%90%90%EF%BC%8C%E6%93%8D%E4%BD%9C%E5%A4%8D%E6%9D%82%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0040cc5d6bcc%22%2C%22answer%22%3A%22%E9%97%AE%E9%A2%98%E8%A7%A3%E5%86%B3%E6%97%B6%E9%97%B4%E9%95%BF%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0041cc5d6bcc%22%2C%22answer%22%3A%22%E6%9C%8D%E5%8A%A1%E8%B4%A8%E9%87%8F%E4%B8%8D%E5%A4%AA%E5%A5%BD%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0042cc5d6bcc%22%2C%22answer%22%3A%22%E6%9C%8D%E5%8A%A1%E6%80%81%E5%BA%A6%E4%B8%8D%E5%A5%BD%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0043cc5d6bcc%22%2C%22answer%22%3A%22%E9%85%8D%E9%80%81%E6%9C%8D%E5%8A%A1%E4%B8%8D%E5%A5%BD%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0044cc5d6bcc%22%2C%22answer%22%3A%22%E9%85%8D%E9%80%81%E5%9F%8E%E5%B8%82%E5%A4%AA%E5%B0%91%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0045cc5d6bcc%22%2C%22answer%22%3A%22%E5%85%B6%E4%BB%96%22%2C%22check%22%3A0%7D%5D%7D%2C%7B%22questionId%22%3A%2270a69efd-4d60-11e6-a878-0021cc5d6bcm%22%2C%22question%22%3A%22%E5%A6%82%E6%9E%9C%E4%B9%90%E7%BA%AF%E5%81%9A%E5%88%B0%E4%BB%A5%E4%B8%8B%E5%93%AA%E4%BA%9B%E7%82%B9%EF%BC%8C%E6%82%A8%E4%BC%9A%E6%9B%B4%E6%84%BF%E6%84%8F%E5%90%91%E5%88%AB%E4%BA%BA%E6%8E%A8%E8%8D%90%E4%B9%90%E7%BA%AF%3F(%E5%A4%9A%E9%80%89)%22%2C%22remark%22%3A%22%22%2C%22sequence%22%3A2%2C%22status%22%3A2%2C%22statusName%22%3A%22%E5%A4%A7%E4%BA%8E6%E5%88%86%22%2C%22flagScore%22%3A0%2C%22answerItemList%22%3A%5B%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0046cc5d6bcc%22%2C%22answer%22%3A%22%E5%AE%9A%E4%BB%B7%E6%9B%B4%E5%90%88%E7%90%86%E4%B8%80%E7%82%B9%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0047cc5d6bcc%22%2C%22answer%22%3A%22%E4%BC%98%E6%83%A0%E6%B4%BB%E5%8A%A8%E6%9B%B4%E5%A4%9A%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0048cc5d6bcc%22%2C%22answer%22%3A%22%E6%8F%90%E5%8D%87%E4%BA%A7%E5%93%81%E6%80%A7%E4%BB%B7%E6%AF%94%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0049cc5d6bcc%22%2C%22answer%22%3A%22%E9%85%8D%E9%80%81%E6%9C%8D%E5%8A%A1%E6%9B%B4%E5%8A%A0%E5%AE%8C%E5%96%84%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0050cc5d6bcc%22%2C%22answer%22%3A%22%E4%BA%A7%E5%93%81%E6%8F%90%E4%BE%9B%E6%9B%B4%E4%B8%B0%E5%AF%8C%E7%9A%84%E5%8F%A3%E5%91%B3%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0051cc5d6bcc%22%2C%22answer%22%3A%22%E4%BA%A7%E5%93%81%E5%8F%A3%E6%84%9F%E6%9B%B4%E5%AE%8C%E5%96%84%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0052cc5d6bcc%22%2C%22answer%22%3A%22%E5%8C%85%E8%A3%85%E5%81%9A%E7%9A%84%E6%9B%B4%E7%B2%BE%E7%BE%8E%EF%BC%8C%E6%9B%B4%E5%90%B8%E5%BC%95%E4%BA%BA%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0053cc5d6bcc%22%2C%22answer%22%3A%22%E6%9B%B4%E5%A4%9A%E5%88%9B%E6%96%B0%E6%96%B0%E5%93%81%E5%93%81%E7%B1%BB%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0054cc5d6bcc%22%2C%22answer%22%3A%22%E5%A4%9A%E5%81%9A%E6%9C%89%E8%B6%A3%E6%9C%89%E6%84%8F%E4%B9%89%E7%9A%84%E6%B4%BB%E5%8A%A8%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0055cc5d6bcc%22%2C%22answer%22%3A%22%E4%BC%98%E5%8C%96%E7%BD%91%E4%B8%8A%E8%B4%AD%E4%B9%B0%E4%B9%90%E7%BA%AF%E7%9A%84%E6%93%8D%E4%BD%9C%E6%B5%81%E7%A8%8B%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0056cc5d6bcc%22%2C%22answer%22%3A%22%E6%8A%95%E8%AF%89%E5%A4%84%E7%90%86%E6%95%88%E7%8E%87%E6%8F%90%E9%AB%98%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0057cc5d6bcc%22%2C%22answer%22%3A%22%E6%8F%90%E5%8D%87%E5%AE%A2%E6%9C%8D%E5%AF%B9%E6%8E%A5%E6%80%81%E5%BA%A6%22%2C%22check%22%3A1%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0058cc5d6bcc%22%2C%22answer%22%3A%22%E5%A4%9A%E5%81%9A%E5%93%81%E7%89%8C%E6%95%99%E8%82%B2%E5%AE%A3%E4%BC%A0%EF%BC%8C%E8%AE%A9%E4%BA%BA%E6%9B%B4%E4%BA%86%E8%A7%A3%E8%BF%99%E4%B8%AA%E5%93%81%E7%89%8C%22%2C%22check%22%3A0%7D%2C%7B%22otherRemark%22%3A%22%22%2C%22answerId%22%3A%2245ab7e63-4d64-11e6-a878-0059cc5d6bcc%22%2C%22answer%22%3A%22%E5%85%B6%E4%BB%96%22%2C%22check%22%3A0%7D%5D%7D%5D%7D%5D%2C%22naireStatus%22%3A2%2C%22naireName%22%3A%22%E6%9C%AA%E7%AD%94%22%2C%22orderNo%22%3A%22%22%7D%5D";
            temp = URLDecoder.decode(temp, "utf-8");
            List list = JsonUtils.getListByArray(QuestionnaireVo.class, (String)temp);
            this.mallAskInterface.saveAire(bindCode, orderNo, "10003341782013717652996", Integer.valueOf(1), "\u6d6a\u82b1", list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baseJsonVo;
    }
}

