/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.controller.deliver;

import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.controller.deliver.ExpressController;
import cc.lechun.mall.entity.deliver.OrderDeliverRecordVo;
import cc.lechun.mall.entity.reunion.sfExpress.Order;
import cc.lechun.mall.iservice.deliver.DeliverRouteInterface;
import cc.lechun.utils.shunfeng.ShunFenUtils;
import cc.lechun.utils.shunfeng.entity.SfCallbackRequest;
import cc.lechun.utils.yto.YtoUtils;
import cc.lechun.utils.yto.entity.CallBackWaybillRoute;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/express"})
public class ExpressController {
    private static final Logger log = LoggerFactory.getLogger(ExpressController.class);
    @Autowired
    private DeliverRouteInterface routeInterface;
    @Autowired
    private ShunFenUtils shunFenUtils;
    @Autowired
    private YtoUtils ytoUtils;

    @RequestMapping(value={"/getRouteInfoForWexin"})
    public List<OrderDeliverRecordVo> getRouteInfoForWexin(String orderNo) {
        List recordVos = this.routeInterface.getRouteInfoForWexin(orderNo);
        return recordVos;
    }

    @RequestMapping(value={"/kuaidi100CallBack"})
    public void kuaidi100CallBack(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("\u5feb\u9012100\u56de\u8c03\u5f00\u59cb\u3002\u3002\u3002\u3002\u3002\u3002");
        NoticeResponse resp = new NoticeResponse(this);
        resp.setResult(false);
        resp.setReturnCode("500");
        resp.setMessage("\u4fdd\u5b58\u5931\u8d25");
        try {
            String param = request.getParameter("param");
            log.info(param);
            BaseJsonVo js = this.routeInterface.expressCallBack("kuaidi100", param);
            if (js.isSuccess()) {
                resp.setResult(true);
                resp.setReturnCode("200");
            }
            log.info("\u5feb\u9012100\u56de\u8c03\u7ed3\u675f\u3002\u3002\u3002\u3002\u3002\u3002");
            response.getWriter().print(JsonUtils.toJson((Object)resp, (boolean)false));
        }
        catch (Exception e) {
            resp.setMessage("\u4fdd\u5b58\u5931\u8d25" + e.getMessage());
            response.getWriter().print(JsonUtils.toJson((Object)resp, (boolean)false));
        }
    }

    @RequestMapping(value={"/YtoTraceTest"})
    public BaseJsonVo YtoTrace(String number) {
        return BaseJsonVo.success((Object)this.ytoUtils.trace(number));
    }

    @RequestMapping(value={"/YtoCallBackTest"})
    @ResponseBody
    public void YtoCallBackTest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.info("YTO\u56de\u8c03\u5f00\u59cb\u3002\u3002\u3002\u3002\u3002\u3002");
        log.info("YTO\u56de\u8c03\u5f00\u59cb\u3002\u3002\u3002\u3002\u3002\u3002" + JsonUtils.toJson((Object)request.getParameterMap(), (boolean)false));
        HashMap<String, Object> resp = new HashMap<String, Object>();
        String txLogisticID = "";
        try {
            Map params = request.getParameterMap();
            String logistics_interface = ((String[])params.get("logistics_interface"))[0];
            String data_digest = ((String[])params.get("data_digest"))[0];
            String type = ((String[])params.get("type"))[0];
            String clientId = ((String[])params.get("clientId"))[0];
            BaseJsonVo js = this.routeInterface.YtoCallBack(logistics_interface, data_digest, type, clientId);
            CallBackWaybillRoute route = (CallBackWaybillRoute)js.getValue();
            if (route != null) {
                txLogisticID = route.getTxLogisticID();
            }
            if (js.isSuccess()) {
                resp.put("logisticProviderID", "YTO");
                resp.put("txLogisticID", txLogisticID);
                resp.put("success", true);
            }
            log.info("YTO\u56de\u8c03\u7ed3\u675f\u3002\u3002\u3002\u3002\u3002\u3002");
            response.getWriter().print(JsonUtils.toJson(resp, (boolean)false));
        }
        catch (Exception e) {
            log.error(e.getMessage());
            resp.put("logisticProviderID", "YTO");
            resp.put("txLogisticID", txLogisticID);
            resp.put("success", false);
            resp.put("reason", "S10");
            response.getWriter().print(JsonUtils.toJson(resp, (boolean)false));
        }
    }

    @RequestMapping(value={"/shunfengtraceTest"})
    public BaseJsonVo shunfengtraceTest(String billNo, String phone) throws UnsupportedEncodingException {
        return BaseJsonVo.success((Object)this.shunFenUtils.trace(billNo, phone));
    }

    @RequestMapping(value={"/shunFengCallback"})
    @ResponseBody
    public void shunFengCallback(@RequestBody SfCallbackRequest request, HttpServletResponse response) throws IOException, UnsupportedEncodingException {
        log.info("\u987a\u4e30\u8def\u7531\u63a8\u9001\u54cd\u5e94\u53c2\u6570 shunfeng/callback  content:" + JsonUtils.toJson((Object)request, (boolean)false));
        HashMap<String, String> resp = new HashMap<String, String>();
        resp.put("return_code", "1000");
        resp.put("return_msg", "\u7cfb\u7edf\u5f02\u5e38");
        BaseJsonVo js = this.routeInterface.expressCallBack("shunfeng", JsonUtils.toJson((Object)request, (boolean)false));
        log.info("\u987a\u4e30\u56de\u8c03\uff1a" + JsonUtils.toJson((Object)js, (boolean)false));
        if (js.isSuccess()) {
            resp.put("return_code", "0000");
            resp.put("return_msg", "\u6210\u529f");
        }
        response.getWriter().print(JsonUtils.toJson(resp, (boolean)false));
    }

    @RequestMapping(value={"/shunFengProduce"})
    public BaseJsonVo shunFengProduce() throws IOException, UnsupportedEncodingException {
        return this.shunFenUtils.produce(new Order());
    }
}

